<?php

use Illuminate\Support\Facades\Route;
// Front
use App\Http\Controllers\front\HomeController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\View;

use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\auth\OtpLoginController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/***********************************************ADMIN*****************************************************/


Route::get('/test-mail', function () {
    try {
        Mail::raw('Payment received successfully.', function ($message) {
            $message->to('irfankhanisolutions@gmail.com')
                ->subject('Test Email from Smasindia');
        });

        return 'Email sent successfully!';
    } catch (\Exception $e) {
        return 'Failed to send email: ' . $e->getMessage();
    }
});


Route::get('/clear', function () {
    
    
    Artisan::call('route:clear');     
    Artisan::call('route:cache');     
    Artisan::call('config:cache');    
    Artisan::call('cache:clear');     
    Artisan::call('view:clear');      

    return 'All caches (route, config, view, app) cleared!';
});

Route::get('/maintenance-clear', function () {
    // Clear various Laravel caches
    Artisan::call('route:clear');
    Artisan::call('route:cache');
    Artisan::call('config:cache');
    Artisan::call('cache:clear');
    Artisan::call('view:clear');

    // Remove the public/storage symlink if it exists
    $storageLink = public_path('storage');
    if (File::exists($storageLink)) {
        File::delete($storageLink);
    }

    // Remove the style.css file if it exists
    $cssFile = public_path('style.css');
    if (File::exists($cssFile)) {
        File::delete($cssFile);
    }

    return 'All caches cleared, storage link and style.css deleted if they existed.';
});


Route::get('/df', function () {
    return 'Homepage is working';
});



Route::get('/public', function () {
    return redirect('/');
});

Route::get('/publics', function () {
    $ua = request()->header('user-agent');
    $sanitized = preg_replace('/[\r\n]+/', '', $ua);
    Log::info('Sanitized User-Agent: ' . $sanitized);

    return response("Logged safely.");
});


// Home page

Route::get('/home', [HomeController::class, 'home'])->name('home');
Route::get('/services', [HomeController::class, 'Services'])->name('home.services');
// About-us
Route::get('/about-us', [HomeController::class, 'AboutUs'])->name('home.aboutus');
// global-company
Route::get('global-company', [HomeController::class, 'GlobalCompany'])->name('home.global_company');

// News Release
Route::get('news-release/events', [HomeController::class, 'Events'])->name('home.events');
// collaboration
Route::get('news-release/collaborations', [HomeController::class, 'Collaboration'])->name('home.collaboration');
// csr
Route::get('news-release/csr', [HomeController::class, 'Csr'])->name('home.csr');
// others
Route::get('others', [HomeController::class, 'Others'])->name('home.others');
// faqs
Route::get('faqs', [HomeController::class, 'Faqs'])->name('home.faqs');
// blog
Route::get('blog', [HomeController::class, 'Blog'])->name('home.blog');
// blog-details
Route::get('why-smas-india-car-subscription-is-the-best-way-to-get-your-dream-car/', [HomeController::class, 'whySmasIndiaCarSubscriptionIsTheBestWayToGetYourDremCar'])->name('home.why_smas_india_car_subscription_is_the_best_way_to_get_your_dream_car');
Route::get('heres-what-industry-insiders-say-about-car-lease-in-india/', [HomeController::class, 'HeresWhatIndustryInsidersSayAboutCarLeaseInIndia'])->name('home.heres_what_industry_insiders_say_about_car_lease_in_india');
Route::get('going-digital-is-the-new-black/', [HomeController::class, 'GoingDigitalIsTheNewBlack'])->name('home.going_digital_is_the_new_black');
Route::get('how-can-vehicle-leasing-help-your-business-operate-smoothly-post-covid-19/', [HomeController::class, 'HowCanVehicleLeasingHelpYourBusinessOperateSmoothlyPostCovid'])->name('home.how_can_vehicle_leasing_help_your_business_operate_smoothly_post_covid_19');
Route::get('how-smas-india-delivers-top-notch-fleet-management-service-at-your-doorstep/', [HomeController::class, 'howSmasIndiaDeliversTopNotchFleetManagementServiceAtYourDoorstep'])->name('home.how_smas_india_delivers_top_notch_fleet_management_service_at_your_doorstep');
Route::get('4-questions-to-ask-your-fleet-consultancy-service-provider/', [HomeController::class, 'QuestionsToAskYourFleetConsultancyServiceProvider'])->name('home.questions_to_ask_your_fleet_consultancy_service_provider');
Route::get('leasing-remedy-to-navigate-through-market-slowdown/', [HomeController::class, 'LeasingRemedyToNavigateThroughMarketSlowdown'])->name('home.leasing_remedy_to_navigate_through_market_slowdown');
Route::get('leasing-industry-in-india-what-today-tomorrow-holds/', [HomeController::class, 'LeasingIndustryInIndiaWhatTodayTomorrowHolds'])->name('home.leasing_industry_in_india_what_today_tomorrow_holds');
Route::get('bs6-compliance-for-vehicles-what-corporate-fleet-owners-must-know/', [HomeController::class, 'Bs6ComplianceForVehiclesWhatCorporateFleetOwnersMustKnow'])->name('home.bs6_compliance_for_vehicles_what_corporate_fleet_owners_must_know');
Route::get('why-vehicle-ownership-costs-more-to-new-businesses-and-what-can-they-do-about-it/', [HomeController::class, 'WhyVehicleOwnershipCostsMoreToNewBusinessesAndWhatCanTheyDoAboutIt'])->name('home.why_vehicle_ownership_costs_more_to_new_businesses_and_what_can_they_do_about_it');
Route::get('why-new-businesses-are-leaning-more-more-towards-vehicle-leasing-services/', [HomeController::class, 'WhyNewBusinessesAreLeaningMoreMoreTowardsVehicleLeasingServices'])->name('home.why_new_businesses_are_leaning_more_more_towards_vehicle_leasing_services');
Route::get('can-vehicle-leasing-profit-a-business-and-enhance-its-employee-retention-rate/', [HomeController::class, 'CanVehicleLeasingProfitaBusinessAndEnhanceItsEmployeeRetentionRate'])->name('home.can_vehicle_leasing_profit_a_business_and_enhance_its_employee_retention_rate');
Route::get('how-to-select-a-reliable-vehicle-leasing-partner-in-india/', [HomeController::class, 'HowToSelectaReliableVehicleLeasingPartnerInIndia'])->name('home.how_to_select_a_reliable_vehicle_leasing_partner_in_india');

Route::get('blog/blog-details', [HomeController::class, 'BlogDetails'])->name('home.blog_datels');
// contact
Route::get('contact', [HomeController::class, 'Contact'])->name('home.contact');
// careers
Route::get('careers', [HomeController::class, 'Careers'])->name('home.careers');
// privacy-policy
Route::get('privacy-policy', [HomeController::class, 'PrivacyPolicy'])->name('home.privacy_policy');
// anti-policy
// Route::get('anti-policy', [HomeController::class, 'AntiPolicy'])->name('home.anti_policy');
Route::get('compliance', [HomeController::class, 'compliance'])->name('home.compliance');

Route::get('insurance-grievance-redressal-procedure-request-form', [HomeController::class, 'InsuranceGrievanceRedressalProcedureRequestForm'])->name('home.insurance_grievance_redressal_procedure_request_form');
Route::post('send-enquiry', [HomeController::class, 'sendEnquiry'])->name('home.send_enquiry');
Route::post('redressal-procedure-form', [HomeController::class, 'RedressalProcedureForm'])->name('home.redressal_procedure_form');



Route::get('search', [HomeController::class, 'searchRedirect'])->name('home.search');
Route::get('thank-you', [HomeController::class, 'ThankYou'])->name('home.thank_you');

// sitemap
Route::get('/sitemap.xml', [HomeController::class, 'Sitemap'])->name('home.sitemap');





Route::prefix('bp')->group(function () {
    Route::get('/', [OtpLoginController::class, 'showLoginForm'])->name('login');
    Route::post('bp', [OtpLoginController::class, 'sendOtp'])->name('login.send_otp'); // Used for initial login
    
    // --- VERIFICATION & FORGET PASSWORD FLOW ---
    Route::get('verify-otp', [OtpLoginController::class, 'showOtpForm'])->name('otp.verify');
    Route::post('verify-otp', [OtpLoginController::class, 'verifyOtp'])->name('otp.process');
    
    // NEW ROUTES: Forget Password and Resend OTP
    Route::get('forgot-password', [OtpLoginController::class, 'showForgetPasswordForm'])->name('password.request'); // Show form
    Route::post('forgot-password', [OtpLoginController::class, 'sendOtpForPasswordReset'])->name('password.email'); // Process email

    Route::post('resend-otp', [OtpLoginController::class, 'resendOtp'])->name('otp.resend'); // Resend OTP from verify screen
    
    // --- PROTECTED DASHBOARD ROUTES ---
    Route::middleware('adminAuth')->group(function () {
        Route::post('logout', [OtpLoginController::class, 'logout'])->name('logout'); 
        Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('enquiries/download', [DashboardController::class, 'downloadEnquiries'])->name('enquiries.download');
    });
});
    
    