@extends('front.layouts.masterhome')
@section('meta_title', 'Privacy Policy | SMAS India | Protecting Your Data and Privacy')
@section('meta_description', 'Read the privacy policy of SMAS India to understand how we collect, use, and protect your personal data. We are committed to safeguarding your privacy while using our vehicle leasing and fleet management services.')



@section('section')
<nav></nav>
<!DOCTYPE html>
<div class="no-bottom no-top" id="content">
    <div id="top"></div>

    <!-- section begin -->
    <section id="subheader" class="jarallax text-light"> <img src="{{ asset('front') }}/images/background/compl.jpg"
            class="jarallax-img" alt="">
        <div class="center-y relative text-center">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 text-center">
                        <h1>Privacy Policy</h1>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>
    <!-- section close -->

    <section aria-label="section" class="privacy">
        <div class="container">
            <div class="row align-items-center">

                <div class="clearfix"></div>
                <div class="col-lg-6">
                    <div class="careers1">
                        <img src="{{ asset('front') }}/./images/privacy.jpg" alt="Privacy Policy" class="img-fluid w-100">
                    </div>
                </div>
                <div class="col-lg-6">
                    <p class="sumo1">Sumitomo Corporation is a Japanese multinational company
                        established in December 1919
                        with it’s base in Tokyo. Sumitomo
                        Corporation’s origin dates back to the 17th century, when Mr. Masatomo Sumitomo opened a
                        book and medicine shop in
                        Kyoto. Masatomo wrote and left for posterity a document entitled “Monjuin Shiigaki
                        (Founder’s Precepts)”, describing how
                        a merchant should conduct business. Forming the basis of Sumitomo’s Business Philosophy
                        of pursuing integrity and sound
                        management rather than easy gains, these teachings have been passed down and adhered to
                        across the Sumitomo Group for
                        400 years, right up until today. The group started its operations in India with Sumitomo
                        Corporation India Private
                        Limited in 1997 and has now ventured into Car Auto Leasing segment with SMAS Auto
                        Leasing India Pvt Ltd, in November
                        2013 and the company is not only restricted to cars but also leases out other vehicles
                        as per the customer needs.</p>
                </div>
            </div>
        </div>

        <div class="container mt-5 pcover">
            <div class="row text-justify">
                <div class="col-lg-12">
                    <p><strong>What does this privacy policy cover?</strong></p>
                    <p>This privacy policy is to inform you regarding the use of your personal information which
                        is collected during your visit
                        to one of our websites.</p>
                    <p>This privacy policy applies to our website, however there may be occasions where there is
                        a need to have a slightly
                        different privacy policy. Whenever a website of SMAS Auto Leasing India Pvt Ltd has a
                        different privacy policy it will
                        be made clear that the privacy policy differs from this general SMAS privacy policy. On
                        your journey around the SMAS
                        website please check the privacy policy of website you visit and do not assume that this
                        privacy policy applies to all
                        other Sumitomo group company websites.</p>

                    <p><strong>Who is responsible for the personal information collected on this site?</strong>
                    </p>
                    <p>Your personal data is controlled ultimately by SMAS Auto Leasing India Pvt Ltd., a
                        company registered under the laws of
                        India, whose registered office is at 404, 4th Floor, Worldmark 2, Asset No. 8, Aerocity
                        Hospitality District, New
                        Delhi-110037.</p>

                    <p><strong>Special Notice – if you are under 18 years old</strong></p>
                    <p>Our website is not aimed at individuals under 18 years old and we will not collect, use,
                        provide or process in any other
                        form of personal information of individuals under the age of 18 deliberately. We
                        therefore also ask you, if you are
                        under 18 years old or not. Please do not send us your personal information (for example,
                        your name, address and email
                        address).</p>
                    <p>If you are under 18 years old and you nevertheless wish to ask a question or use this
                        website in anyway which requires
                        you to submit your personal information, please get your parent or guardian to do so on
                        your behalf.</p>

                    <p><strong>Purpose of the collection of your data</strong></p>
                    <p>One of the purpose of our website is to inform you of who we are and what we do. We
                        collect and use personal information
                        (including name, address, telephone number and email) to provide you with the required
                        services, or it’s information. We
                        would therefore use your personal information in order to:</p>
                    <ul>
                        <li>Respond to queries or requests submitted by you</li>
                        <li>Process orders or applications submitted by you</li>
                        <li>Administer or otherwise carry out our obligations in relation to any agreement you
                            have with us</li>
                        <li>Anticipate and resolve problems with any goods or services supplied to you</li>
                        <li>Create products or services that may meet your needs</li>
                    </ul>

                    <p>To optimise our services we may wish to use your personal data for direct marketing. As
                        we respect your privacy, we will
                        only use your personal data for this purpose when you are aware and if required we will
                        request your consent prior to
                        using your personal data for direct marketing.</p>
                    <p>Additionally, if at any time you wish us to stop using your information for any or all of
                        the above purposes, please
                        contact us as set out below. We will stop the use of your information for such purposes
                        as soon as it is reasonably
                        possible to do so.</p>
                    <p>In addition, the collected personal data will (occasionally) be transferred to selected
                        third parties, which may be
                        located outside of India as part of the services offered to you through our site.</p>
                    <p>These third parties will not use your personal information for any other purposes than
                        what we have agreed with them.
                        SMAS requests those third parties to implement adequate levels of protection in order to
                        safeguard your personal
                        information.</p>
                    <p>We respect your personal information and therefore, we will take steps to ensure that
                        your privacy rights continue to be
                        protected if we transfer your information outside of the India in this way. In addition,
                        if you use our services while
                        you are outside India, your information may be transferred outside India in order to
                        provide you with those services.</p>
                    <p>Except as set out in this privacy policy, we will not disclose any personally
                        identifiable information without your
                        permission unless we are legally entitled or required to do so (for example, if required
                        to do so by legal process or
                        for the purposes of prevention of fraud or other crime) or if we believe that such
                        action is necessary to protect and/or
                        defend our rights, property or personal safety and those of our users/customers or other
                        individuals.</p>
                    <p>Please be assured that we will not use your information for any of the purposes if you
                        have indicated that you do not
                        wish us to use your information in this way when submitting the information or at later
                        stage.</p>

                    <p><strong>Collection of non-personal information</strong></p>
                    <p>We may automatically collect non-personal information about you such as the type of
                        internet browsers you use or the
                        website from which you linked to our website. We may also aggregate details which you
                        have submitted to the site. You
                        cannot be identified from this information and it is only used to assist us in providing
                        an effective service on this
                        web site. We may from time to time supply third parties with this non-personal or
                        aggregated data for uses in connection
                        with this website.</p>

                    <p><strong>Interaction between you and us</strong></p>
                    <p>We are interested in your views, and we value feedback from our clients and visitors, we
                        therefore have set up feedback
                        procedures (notice boards, newsgroups, feedback, email). If at any time this website
                        offers any notice board facilities,
                        newsgroups etc we may collect the personal information that you disclose. Such
                        information will be used in accordance
                        with this privacy policy.</p>
                    <p>However, we can of course not control and be responsible for other parties’ use of the
                        personal information which you
                        make available to them through this website. We encourage you to be careful about what
                        personal information you disclose
                        in this way.</p>

                    <p><strong>Keeping our records accurate</strong></p>
                    <p>We aim to keep our information about you as accurate as possible. If you would like to
                        review, change or delete the
                        details you have supplied us with, please contact us as set out below.</p>

                    <p><strong>Security of your personal data</strong></p>
                    <p>As we value your personal information, we will ensure an adequate level of protection. We
                        have therefore implemented
                        technology and policies with the objective of protecting your privacy from unauthorised
                        access and improper use and will
                        update these measures as new technology becomes available, as appropriate.</p>
                    <p>Use of your personal information submitted to other web sites</p>
                    <p>On our websites, we may have links to other websites or you are referred to our website
                        through a link from another
                        website. As you can imagine, we cannot be responsible for the privacy policies and
                        practices of other websites. Such
                        content is subject to their terms of use and any additional guidelines and privacy
                        information provided in relation to
                        that use on their website.</p>
                    <p>We recommend that you check the policy of each website you visit to better understand
                        your rights and obligations
                        especially when you are submitting any type of content on those third party website.
                        Please contact the owner or
                        operator of such website if you have any concerns or questions.</p>

                    <p><strong>Third Party Links</strong></p>
                    <p>Occasionally at our discretion we may include or offer third party products or services
                        on our website. These third
                        party sites have separate and independent privacy policies. We therefore have no
                        responsibility or liability for the
                        content and activities of these linked sites. Nonetheless we seek to protect the
                        integrity of our site and welcome any
                        feedback about these sites.</p>

                    <p><strong>Cookies policy</strong></p>
                    <p>We use the term “cookies” to refer to cookies and other similar technologies</p>

                    <p><strong>1.What is a cookie?</strong></p>
                    <p>Cookies are small data files that your browser places on your computer or device. Cookies
                        help your browser navigate a
                        website and the cookies themselves cannot collect any information stored on your
                        computer or your files.</p>
                    <p>When a server uses a web browser to read cookies they can help a website deliver a more
                        user-friendly service. To
                        protect your privacy, your browser only gives a website access to the cookies it has
                        already sent to you.</p>

                    <p><strong>2.Why do we use cookies?</strong></p>
                    <p>We use cookies to learn more about the way you interact with our content and help us to
                        improve your experience when
                        visiting our website.</p>
                    <p>Cookies remember the type of browser you use and which additional browser software you
                        have installed. They also
                        remember your preferences, such as language and region, which remain as your default
                        settings when you revisit the
                        website. Cookies also allow you to rate pages and fill in comment forms.</p>
                    <p>Some of the cookies we use are session cookies and only last until you close your
                        browser, others are persistent cookies
                        which are stored on your computer for longer. For further details on the various types
                        of cookies that we use, please
                        read out cookie policy.</p>


                    <p><strong>3.How are third party cookies used?</strong></p>
                    <p>For some of the functions within our websites we use third party suppliers, for example,
                        when you visit a page with
                        videos embedded from or links to YouTube. These videos or links (and any other content
                        from third party suppliers) may
                        contain third party cookies and you may wish to consult the policies of these third
                        party websites for information
                        regarding their use of cookies. For further details on the third party cookies that we
                        use, please click read our page
                        on cookie types.</p>

                    <p><strong>4.How do I reject and delete cookies?</strong></p>
                    <p>We will not use cookies to collect personally identifiable information about you.
                        However, should you wish to do so, you
                        can choose to reject or block the cookies set by Shell or the websites of any third
                        party suppliers by changing your
                        browser settings – see the Help function within your browser for further details. Please
                        note that most browsers
                        automatically accept cookies so if you do not wish cookies to be used you may need to
                        actively delete or block the
                        cookies.</p>
                    <p>You can also visit www.allaboutcookies.org for details on how to delete or reject cookies
                        and for further information on
                        cookies generally.</p>
                    <p>Note, however, that if you reject the use of cookies you will still be able to visit our
                        websites but some of the
                        functions may not work correctly.</p>


                    <p><strong>Limitation of Liability</strong></p>
                    <p>SMAS reserves the right to disclose information submitted to it by the visitor to law
                        enforcement and government
                        agencies upon their requirements as may be requested by them. However SMAS reserves no
                        liability if the said information
                        is used by them for their required usage. The liability of SMAS will be limited to the
                        extent of information shared by
                        it with third parties without the consent of the visitor and includes all personal
                        information only.</p>

                    <p><strong>What Are Your Rights?</strong></p>
                    <p>You have a right to know what personal data we hold about you. You have a right to have
                        incomplete, incorrect,
                        unnecessary or outdated personal data deleted or updated. You have a right to
                        unsubscribe from direct marketing messages
                        and to request that we stop processing your personal data for direct marketing purposes
                        or on other compelling legal
                        grounds. However, if you opt-out from marketing and other communications, critical
                        alerts may still be sent to you.</p>
                    <p>You may exercise your rights by contacting us or by managing your account and choices
                        through available profile
                        management tools on your device and our services.</p>


                    <p><strong>Grievance Redressal Policy</strong></p>
                    <p>SMAS strongly believes in a sincere and transparent approach to its users. You trust and
                        love us and we would never put
                        growth before trust. This policy document aims at minimizing instances of customer
                        complaints, grievances and
                        disappointments via channelized approach, review and redressal. The self-review will be
                        of help in identifying
                        shortcomings in the product features and service delivery. If you’re disappointed, then
                        at some point in time we’ve not
                        done a great enough job.</p>
                    <p>SMAS policy on grievance redressal follows the under noted principles.</p>
                    <ul>
                        <li>Our users are to be treated fairly at all times.</li>
                        <li>Complaints or concerns raised by users are dealt with an open mind, with courtesy
                            and in a timely manner.</li>
                        <li>Users are informed about the channels to escalate their complaints, concerns and
                            grievances within SMAS and their rights
                            if they are not satisfied with the resolution of their complaints.</li>
                        <li>SMAS will take care of all complaints efficiently and fairly as they value each
                            user.</li>
                        <li>All employees at SMAS must work in good faith and without prejudice to the interests
                            of the users.</li>
                    </ul>
                    <p>We understand that customer grievances can happen due to multiple reasons. It can be
                        because of the gap between the
                        promised service levels and the service levels actually offered. Since we are dealing
                        with humans, a lot of grievances
                        can arise due to the attitudinal and the way communication gets done. It can also happen
                        due to the actual errors across
                        the system.</p>
                    <p>Users have complete authority to file a complaint/ share feedback if they are
                        disappointed by services rendered by SMAS.
                        They can give their complaint/ feedback in writing, email, or on the website.</p>
                    <p>In order to make SMAS redressal channels more meaningful and effective, a structured
                        system has been put in place. This
                        system will ensure that the complaints are redressed seamlessly and well within the
                        stipulated timeframe.</p>

                    <p><strong>Awareness of Grievance Redressal System</strong></p>
                    <p>At SMAS, the users’ experience is what we deliberate and focus on. This is why we listen
                        and take the time to know our
                        users and take their concerns seriously. Going skin-deep to analyze and scrutinize, how
                        you would feel from the time you
                        step-in to the website till the time you’re done, helps us evolve and enhance our
                        services. If a user has found our
                        experience simple and incredible we know we are doing something worthy. However, when a
                        user is concerned or has
                        complaints we do everything we can to fix it and make it right.</p>

                    <p><strong>Sensitizing staff on handling complaints</strong></p>
                    <p>Our staff undergoes regular training to ensure that consumers queries and grievances are
                        handled properly. They are
                        encouraged to work in a manner which helps us in building the consumer trust and
                        confidence. This reflects in both the
                        operations as well as the customer communications. Top reasons behind the consumer
                        queries are analysed and worked upon
                        in a way which aims at removal of these reasons from the root. This helps in improving
                        the overall quality of the
                        service levels gradually.</p>


                    <p><strong>How to reach SMAS</strong></p>
                    <p><strong>Level 1:</strong></p>
                    <p>We suggest calling the company helpline number 011-48288300 between 9AM to 6PM.</p>

                    <p><strong>Level 2:</strong></p>
                    <p>If the resolution you received does not meet your expectations, please write to us at
                        grievances@smasindia.com</p>

                    <p><strong>Level 3:</strong></p>
                    <p>If you are still not satisfied, please write to:</p>
                    <address>Grievance Officer<br>
                        406,4thTH Floor, Worldmark – II<br>
                        Asset No 8, Aerocity Hospitality District<br>
                        New Delhi-110037</address>
                    <p>amit.singh@smasindia.com</p>
                    <p>We recommend that customer sends us a query/grievance by logging in his website account
                        and using the ‘Help and Support’
                        section. It is also recommended that the customer writes his complaint reference number
                        provided by our customer care
                        team in all further communication with us regarding a particular issue. This enables us
                        to get more details about the
                        customer and the query quickly and helps to resolve the query faster.</p>
                    <p>Estimated time taken to address your queries, concerns, complaints</p>
                    <p>Suitable timelines have been set for every complaint depending upon the investigations
                        which would be involved in
                        resolving the same. Here are the estimated timelines at various levels of
                        queries/escalations</p>
                    <p>First response to a user’s query/ concern 48 hrs</p>
                    <p>Follow-up queries 72 hrs</p>
                    <p>Escalated cases 7 working days</p>
                    <p>Customer grievances 15 working days</p>
                    <p>Your Consent By using our site, you consent to our privacy policy.</p>

                    <p><strong>Changes to this policy</strong></p>
                    <p>From time to time we may make changes to this privacy policy. If we make any substantial
                        changes to this privacy policy
                        and the way in which we use your personal data we will post these changes on this page
                        and will do our best to notify
                        you of any significant changes. Please check our privacy policy on a regular basis.</p>

                    <p><strong>How you can contact us</strong></p>
                    <p>If you would like to contact SMAS about our privacy policy, please visit our <a
                            href="{{ route('home.contact') }}">contact us page</a>.</p>
                </div>
            </div>
        </div>
    </section>


</div>
@endsection