<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>New Enquiry</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0px 0px 10px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            padding-bottom: 20px;
            border-bottom: 1px solid #ddd;
        }
        .header img {
            max-width: 150px;
        }
        h2 {
            color: #1c3f94;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        table td {
            padding: 8px;
            border-bottom: 1px solid #ddd;
        }
        table td.label {
            font-weight: bold;
            width: 35%;
            background-color: #f7f7f7;
        }
        .footer {
            text-align: center;
            font-size: 12px;
            color: #777;
            margin-top: 20px;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header" style="text-align:center; margin-bottom:20px;">
            <img src="https://www.smasindia.com/front/images/smas_logo.png" alt="SMAS Logo" style="max-width:150px;">
            <h2 style="color:#333; font-family:Arial, sans-serif;">New Enquiry Received</h2>
        </div>
        
        <p>Dear Admin,</p>
        
        <p>We have received a new enquiry via the SMAS India portal. Please find the details below:</p>
        
        <table style="width:100%; border-collapse:collapse; margin-top:10px;">
            <tr>
                <td style="padding:8px; border:1px solid #ddd;"><strong>Full Name:</strong></td>
                <td style="padding:8px; border:1px solid #ddd;">{{ $enquiry->first_name }} {{ $enquiry->last_name }}</td>
            </tr>
            <tr>
                <td style="padding:8px; border:1px solid #ddd;"><strong>Email:</strong></td>
                <td style="padding:8px; border:1px solid #ddd;">{{ $enquiry->email }}</td>
            </tr>
            <tr>
                <td style="padding:8px; border:1px solid #ddd;"><strong>Mobile:</strong></td>
                <td style="padding:8px; border:1px solid #ddd;">{{ $enquiry->mobile }}</td>
            </tr>
            <tr>
                <td style="padding:8px; border:1px solid #ddd;"><strong>Company:</strong></td>
                <td style="padding:8px; border:1px solid #ddd;">{{ $enquiry->company }}</td>
            </tr>
            <tr>
                <td style="padding:8px; border:1px solid #ddd;"><strong>Lease Type:</strong></td>
                <td style="padding:8px; border:1px solid #ddd;">{{ $enquiry->lease_type }}</td>
            </tr>
            <tr>
                <td style="padding:8px; border:1px solid #ddd;"><strong>Request Type:</strong></td>
                <td style="padding:8px; border:1px solid #ddd;">{{ $enquiry->webrequest_type }}</td>
            </tr>
            <tr>
                <td style="padding:8px; border:1px solid #ddd;"><strong>Description:</strong></td>
                <td style="padding:8px; border:1px solid #ddd;">{{ $enquiry->description }}</td>
            </tr>
        </table>
        
        <p style="margin-top:20px;">Please review the enquiry and respond promptly.</p>

        <div class="footer">
            &copy; {{ date('Y') }} SMAS India. All rights reserved.
        </div>
    </div>
</body>
</html>
