@extends('front.layouts.masterhome')
@section('section')
<div class="no-bottom no-top" id="content">
    <div id="top"></div>

    <!-- section begin -->
    <section id="subheader" class="jarallax text-light">
        <img src="{{ asset('front') }}/images/background/new-banner.jpg" class=" jarallax-img" alt="">
        <div class="center-y relative text-center">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 text-center">
                        <h1>CSR Activities</h1>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>
    <!-- section close -->






    <section class="csr-section py-5" style="background-color: #e5e7ef">
        <div class="container">
            <h2 class="mb-4 text-center">Our CSR Objective</h2>
            <p class="csr-content csr-objective-p" style="text-align: center">
                As a responsible corporate entity, SMAI is committed to conducting its
                business lawfully, ethically, and in a socially responsible manner,
                ensuring fairness to all stakeholders.
            </p>
        </div>
    </section>

    <section class="crm-pdf-section py-5">
        <div class="container">
            <h2 class="mb-4 text-center">Our CSR Policy</h2>
            <div class="row mt-5 mb-4">
                <div class="col-lg-7">
                    <p class="csr-content csr-contnet-pdf">
                        The Corporate Social Responsibility policy of SMAI reflects SMAI’s
                        commitment to contribute meaningfully to society beyond mere
                        compliance. In line with the Regulations, the Company pledges to
                        integrate CSR activities into its corporate framework to foster
                        sustainable development, uplift underprivileged communities, and
                        protect the environment. This Policy serves as a guiding document
                        to ensure that CSR initiatives are undertaken systematically and
                        in accordance with the applicable Regulations.
                    </p>
                </div>

                <div class="col-lg-5 csr-pdf">
                    <a href="{{ asset('front') }}/images/csr/SMAS Auto Leasing India CSR Policy 2025 03.04.2025.pdf"
                        target="_blank" style="text-decoration: none; font-size: 20px">
                        <h3 class="mb-4 csr-title" style="text-align: center">
                            SMAS Auto Leasing India CSR Policy 2025
                        </h3>
                        <div class="smas-auto-pdf">
                            <img src="{{ asset('front') }}/images/csr/pdf-file.png" class="img-fluid" width="20%" />
                            <br />
                            <span class="pdf-download">Download</span> SMAS Auto Leasing
                            India CSR Policy 2025
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="csr-committee py-5" style="background-color: #e5e7ef">
        <div class="container">
            <h2 class="mb-5 text-center">The Composition of CSR Committee:</h2>
            <div class="row justify-content-center g-4">
                <!-- Step 1 -->
                <div class="col-md-6">
                    <div
                        class="p-4 border rounded-3 shadow step-box text-center csr-card">
                        <div class="row align-items-center">

                            <!-- Left side image -->
                            <div class="col-4 text-center">
                                <img src="{{ asset('front') }}/images/hidenaga_aoki.jpg" alt="Hidenaga Aoki" class="img-fluid rounded-circle" style="width: 80px; height: 80px; object-fit: cover;" />
                            </div>

                            <!-- Right side content -->
                            <div class="col-8 text-start">
                                <h5 class="fw-bold csr-h5 mb-1">Hidenaga Aoki</h5>
                                <p class="mb-0" style="color: #fff;">Managing Director</p>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- Step 2 -->
                <div class="col-md-6">
                    <div
                        class="p-4 border rounded-3 shadow step-box bg-blue text-center csr-card">
                        <div class="row align-items-center">
                            <div class="col-4 text-center">
                                <img src="{{ asset('front') }}/images/kazuhiro_hasumi.jpg" alt="Kazuhiro Hasumi" class="img-fluid rounded-circle" style="width: 80px; height: 80px; object-fit: cover;" />
                            </div>
                            <div class="col-8 text-start">
                                <h5 class="fw-bold csr-h5">Kazuhiro Hasumi</h5>
                                <p class="mb-0" style="color: #fff">Director</p>
                            </div>


                        </div>
                    </div>
                </div>
                <!-- Step 3 -->
                <div class="col-md-6">
                    <div
                        class="p-4 border rounded-3 shadow step-box bg-yellow text-center csr-card">
                        <div class="row align-items-center">
                            <div class="col-4 text-center">
                                <img src="{{ asset('front') }}/images/rajesh_arora.jpg" alt="Kazuhiro Hasumi" class="img-fluid rounded-circle" style="width: 80px; height: 80px; object-fit: cover;" />
                            </div>
                            <div class="col-8 text-start">
                                <h5 class="fw-bold csr-h5">Rajesh Arora</h5>
                                <p class="mb-0" style="color: #fff">General Manager</p>
                            </div>


                        </div>
                        
                        <!--<div class="row align-items-center">-->
                        <!--       <div class="col-4 text-center">-->
                        <!--   <img src="{{ asset('front') }}/images/kazuhiro_hasumi.jpg" alt="Kazuhiro Hasumi" class="img-fluid rounded-circle" style="width: 80px; height: 80px; object-fit: cover;" />-->
                        <!--   </div>-->
                        <!--   <div class="col-8 text-start">-->

                        <!--   </div>-->
                        <!--</div>-->

                    </div>
                </div>
                <div class="col-md-6">
                    <div
                        class="p-4 border rounded-3 shadow step-box bg-yellow text-center csr-card">
                        <h5 class="fw-bold csr-h5">Amit Singh</h5>
                        <p class="mb-0" style="color: #fff">Company Secretory & General Counsel</p>
                        <!--<div class="row align-items-center">-->
                        <!--                             <div class="col-4 text-center">-->
                        <!--     <img src="{{ asset('front') }}/images/kazuhiro_hasumi.jpg" alt="Kazuhiro Hasumi" class="img-fluid rounded-circle" style="width: 80px; height: 80px; object-fit: cover;" />-->
                        <!--     </div>-->

                        <!--<div class="col-8 text-start">-->

                        <!--     </div>-->

                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="csr-activities py-5">
        <div class="container">
            <h2 class="mb-4 text-center">SMAS India FY2024-25 CSR Activities</h2>
            <p class="mb-4 csr-content">
                <strong>SMAS India</strong> focuses on diverse social causes,
                including assistance to individuals with disabilities, animal welfare,
                environmental conservation, and education. Our CSR initiatives for
                FY2024-25 offer a glimpse into the diverse CSR landscape in the
                region, showcasing our efforts to address pressing social issues and
                create a positive impact on the society.
            </p>

            <div class="table-responsive">
                <table class="table table-bordered text-center align-middle">
                    <thead style="background-color: #2e5cb8; color: white;border-color: #ffffff;">
                        <tr>
                            <th>
                                Promoting education, with a focus on special education and
                                vocational skills.
                            </th>
                            <th>
                                Ensuring environmental sustainability, ecological balance,
                                animal welfare & protection of flora and fauna.
                            </th>
                            <th>
                                Empowering women, orphans and the elderly by establishing
                                homes & hostels.
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>National Association for the Blind</td>
                            <td>Give Me Trees Trust</td>
                            <td>The Earth Saviors Foundation</td>
                        </tr>
                        <tr>
                            <td>Amar Jyoti Charitable Trust</td>
                            <td>Touch & Treat Animal Trust</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Samadhan</td>
                            <td>NeighbourhoodWoof Timarpur Kennels</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>
                                Gakko Bunka
                                Education Society
                            </td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>SOS Children’s Villages of India</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
    <section class="csr-campaign py-5" style="background-color: #e5e7ef">
        <div class="container">
            <h2 class="mb-4 text-center">Our Campaigns at a Glance</h2>
            <!-- Section 1: Tree Plantation -->
            <div class="campaign-section row mt-5 mb-5">
                <div class="col-lg-6">
                    <h3 class="csr-title">
                        1,115 Tree Plantation and Maintenance, Location ITBP, Laknavali
                        Village, Greater Noida - UP
                    </h3>
                    <p class="subheading">
                        As part of our CSR commitment to a sustainable future, we’re proud
                        to collaborate with Give Me Trees Trust, a renowned organization
                        with over 45 years of contribution towards tree plantation and
                        preservation across India.
                    </p>
                    <p>
                        Since its registration under the Indian Trusts Act in 2011, Give
                        Me Trees Trust has made an incredible impact by planting nearly 23
                        million trees across 27 states. Their work goes beyond
                        planting—they’ve been instrumental in spreading awareness about
                        the importance of protecting natural habitats and promoting social
                        forestry.
                    </p>
                    <p>
                        Our SMAS India team, along with our MD Hidenaga Aoki San, had the
                        privilege of meeting Swami Prem Parivartan (Peepal Baba), the
                        visionary founder of Give Me Trees Trust. Through this
                        partnership, we aim to increase green cover, enhance carbon
                        absorption, and improve air quality—ensuring environmental
                        sustainability for future generations.
                    </p>
                    <p>Together, let’s grow a greener, cleaner tomorrow!</p>
                </div>
                <div class="col-lg-6">
                    <div class="row g-2 image-gallery">
                        <div class="col-6">
                            <img src="{{ asset('front') }}/images/csr/greentrees1.jpg"
                                alt="Tree Plantation Event"
                                class="img-fluid shadow-sm" />
                        </div>
                        <div class="col-6">
                            <img
                                src="{{ asset('front') }}/images/csr/greentrees2.jpg"
                                alt="Give Me Trees Trust Logo"
                                class="img-fluid shadow-sm" />
                        </div>
                        <div class="col-6">
                            <img
                                src="{{ asset('front') }}/images/csr/greentrees3.jpg"
                                alt="Team with Peepal Baba"
                                class="img-fluid shadow-sm" />
                        </div>
                        <div class="col-6">
                            <img
                                src="{{ asset('front') }}/images/csr/greentrees4.jpg"
                                alt="Volunteers Planting Trees"
                                class="img-fluid shadow-sm" />
                        </div>
                    </div>
                </div>
            </div>

            <!-- Section 2: Pre-vocational Skills Training -->
            <div class="campaign-section row mt-5">
                <div class="col-lg-6 order-2 order-lg-1">
                    <div class="row g-2 image-gallery">
                        <div class="col-6">
                            <img
                                src="{{ asset('front') }}/images/csr/amarjyoti1.jpg"
                                alt="Tree Plantation Event"
                                class="img-fluid shadow-sm" />
                        </div>
                        <div class="col-6">
                            <img
                                src="{{ asset('front') }}/images/csr/amarjyoti2.jpg"
                                alt="Give Me Trees Trust Logo"
                                class="img-fluid shadow-sm" />
                        </div>
                        <div class="col-6">
                            <img
                                src="{{ asset('front') }}/images/csr/amarjyoti3.jpg"
                                alt="Team with Peepal Baba"
                                class="img-fluid shadow-sm" />
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 order-1 order-lg-2">
                    <h3 class="csr-title">
                        Pre-vocational skills training for persons with disabilities: An
                        imperative for Empowerment
                    </h3>
                    <p class="subheading">
                        At SMAS Auto Leasing India Private Limited, we believe in creating
                        a more inclusive and empowered future for all. As part of our CSR
                        initiative, we are proud to collaborate with Amar Jyoti Charitable
                        Trust - India, an institute dedicated to inclusive education for
                        children with and without disabilities.
                    </p>
                    <p>
                        Founded in 1981, Amar Jyoti has been a pioneer in building
                        environments where every child, regardless of ability, can thrive
                        and reach their full potential.
                    </p>
                    <p>
                        Team SMAS India, along with our MD Hidenaga Aoki San, was honored
                        to meet Dr. Uma Tuli, Padma Shri & the founder of Amar Jyoti
                        Charitable Trust. SMAS India's contribution is aimed at supporting
                        their pre-vocational skill development programs, which begin as
                        early as Class III. These programs empower students by nurturing
                        essential life and vocational skills — from art & craft and
                        tailoring to pottery and computer training. The goal is to instill
                        confidence, self-reliance, and the tools needed to build a
                        brighter future.
                    </p>
                    <p>
                        This partnership reflects our ongoing commitment to driving social
                        change through education, inclusion, and opportunity.
                    </p>
                    <p>Let’s build a future that works for everyone!</p>
                </div>
            </div>
            
             <div class="campaign-section row mt-5 mb-5">
                <div class="col-lg-6">
                    <h3 class="csr-title">
                       Digital Empowerment for the Visually Impaired (NAB Delhi):
                    </h3>
                    <p class="subheading">
                        As part of our enduring commitment to creating a more inclusive and equitable society, SMAS India is proud to partner with the National Association for the Blind (NAB), Delhi—an institution that has been empowering visually impaired individuals since 1979 through education, skill development, and advocacy.
                    </p>
                    <p>
                        In alignment with NAB Delhi’s mission to integrate the visually impaired into mainstream society, our collaboration focused on transforming both the digital and physical learning environment. SMAS India funded the installation of assistive-technology-enabled desktops, providing over 100 students the ability to learn independently and interact meaningfully with digital tools. This step toward digital inclusion is vital in today’s increasingly technology-driven world.       
                    </p>
                    <p>
                        To ensure every child can access education safely and comfortably, we also supported the upgrade of transportation infrastructure—making school commutes more reliable and secure. Additionally, ergonomic furniture was provided to foster inclusive classroom environments where both physical comfort and effective learning coexist.
                    </p>
                    <p>But our impact goes beyond infrastructure. By interacting with the children and educators, our team witnessed firsthand how inclusive spaces fuel confidence, ambition, and dignity. This initiative reflects our unwavering belief that every child, regardless of physical ability, deserves the opportunity to learn, grow, and lead.</p>
                    
                    <p>Together with NAB Delhi, we are not just transforming classrooms—we are breaking barriers and building a future where empowerment through inclusion becomes the norm, not the exception.</p>
                    
                    <h5 class="mb-2"><i>Project Impact:</i></h5>
  <p>
    Through our partnership, we focused on enhancing accessibility, mobility, and learning infrastructure for visually impaired students. Key achievements include:
  </p>

  <ul class="list-unstyled mt-3">
    <li class="mb-3">
      ✅ <strong>Digital Empowerment:</strong> Installation of all-in-one desktops equipped with assistive technology, enabling 100+ students to access digital learning independently.
    </li>
    <li class="mb-3">
      ✅ <strong>Safe & Reliable Transport:</strong> Upgraded school transportation to ensure safe and comfortable commutes for students across Delhi.
    </li>
    <li class="mb-3">
      ✅ <strong>Inclusive Learning Spaces:</strong> Provided ergonomic furniture to create a more accessible and engaging training environment.
    </li>
  </ul>
                </div>
                <div class="col-lg-6">
                    <div class="row g-2 image-gallery">
                        <div class="col-12">
                            <img src="{{ asset('front') }}/images/csr/digital1.jpg"
                                alt="Tree Plantation Event"
                                class="img-fluid shadow-sm" />
                        </div>
                        <div class="col-12">
                            <img
                                src="{{ asset('front') }}/images/csr/digital2.jpeg"
                                alt="Give Me Trees Trust Logo"
                                class="img-fluid shadow-sm" />
                        </div>
                        
                    </div>
                </div>
                
                
            </div>
            
            
            
            <!--Safe Learning Through Seismic-Resistant School Rebuild, New Delhi Japanese School (GBES)-->
            
            <div class="campaign-section row mt-5">
                <div class="col-lg-6 order-2 order-lg-1">
                    <div class="row g-2 image-gallery">
                        <div class="col-12">
                            <img
                                src="{{ asset('front') }}/images/csr/safe_learning1.jpg"
                                alt="Tree Plantation Event"
                                class="img-fluid shadow-sm" />
                        </div>
                        <div class="col-12">
                            <img
                                src="{{ asset('front') }}/images/csr/safe_learning2.jpg"
                                alt="Give Me Trees Trust Logo"
                                class="img-fluid shadow-sm" />
                        </div>
                      
                    </div>
                </div>
                <div class="col-lg-6 order-1 order-lg-2">
                    <h3 class="csr-title">
                        Safe Learning Through Seismic-Resistant School Rebuild, New Delhi Japanese School (GBES)
                    </h3>
                    <p class="subheading">
                        Education is a powerful catalyst for change—and at SMAS India, we believe that every child deserves to learn in a safe, modern, and inspiring environment. That’s why we are honored to support the Gakko Bunka Education Society (GBES) in their mission to rebuild the New Delhi Japanese School, a longstanding symbol of Indo-Japanese educational collaboration since 1991.
                    </p>
                    <p>
                        The original school building, though cherished, had aged beyond structural safety norms, particularly in regard to seismic preparedness. Recognizing the urgent need for a safer future for its students, GBES initiated a visionary scrap-and-rebuild project—one focused on earthquake resistance, environmental sustainability, and upgraded learning facilities.
                    </p>
                    <p>
                        Our partnership with GBES is rooted in more than philanthropy; it’s a shared vision for nurturing resilient global citizens. The new infrastructure will feature eco-conscious upgrades such as a sustainable diesel generator, while classroom environments will be redesigned to support modern pedagogy and emotional wellbeing.
                    </p>
                    <p>
                       Our leadership team, including MD Mr. Hidenaga Aoki, Mr Gaurav Kaushik, Mr Rajesh Arora & Mr Pankaj S Gurmukhani met with the GBES stakeholders to reinforce our commitment. This initiative symbolizes our dedication to building not just schools, but legacies of safety, global understanding, and innovation.
                    </p>
                    <p>We believe the foundation of any progressive society lies in its classrooms. Through this partnership, we aim to rebuild better—creating safe havens for learning and launching pads for future leaders.</p>
                    <h5 class="mb-2"><i>Why This Project Matters</i></h5>
  <p>
    The school’s current building, constructed in 1991, no longer meets modern seismic safety standards. Rather than temporary fixes, GBES has undertaken a scrap-and-build project to ensure:
  </p>

  <ul class="list-unstyled mt-3">
    <li class="mb-3">
        ✅ Earthquake-resistant infrastructure for student and staff safety    </li>
    <li class="mb-3">
      ✅ Sustainable upgrades, including an eco-friendly diesel generator
    </li>
    <li class="mb-3">
     ✅ Enhanced learning spaces that meet 21st-century educational needs
    </li>
  </ul>
  
 
                </div>
            </div>
            
            
            <!--Healthcare Access and Dignity for the Abandoned and Elderly, (Earth Saviors Foundation)-->
            
            <div class="campaign-section row mt-5">
                <div class="col-lg-6 order-1 order-lg-2">
                    <h3 class="csr-title">
                        Healthcare Access and Dignity for the Abandoned and Elderly, (Earth Saviors Foundation)
                    </h3>
                    <p class="subheading">
                        At SMAS India, we believe that dignity, care, and respect are the fundamental rights of every human being—especially those who have been marginalized or abandoned. In alignment with this ethos, we have partnered with The Earth Saviors Foundation, an extraordinary organization that has dedicated itself to the care of elderly and differently-abled individuals who have no one else to turn to.
                    </p>
                    <p>
                        The Earth Saviors Foundation has created a nurturing environment for over a thousand residents, many of whom are rescued from the streets in dire medical or psychological conditions.
                    </p>
                    <p>
                        This partnership reflects our belief that corporate responsibility must extend to the most forgotten corners of society. By contributing to their infrastructure, we are contributing to their humanity—and our own.
                    </p>
                    <p>
                       We are deeply grateful to the Foundation for allowing us to be part of their selfless work. Together, we reaffirm that the strength of a society is not in how it treats its privileged, but in how it uplifts its most vulnerable.
                    </p>
                   
                    <h5 class="mb-2"><i>Our Contribution & Impact</i></h5>
  <p>
    Through this collaboration, SMAS India has donated:
  </p>

  <ul class="list-unstyled mt-3">
    <li class="mb-3">
        ✅ 10 medical beds with mattresses </li>
    <li class="mb-3">
        ✅ 5 electronic wheelchairs    </li>
    
  </ul>
   <p>
    These contributions are already transforming lives:
  </p>
  
  <ul class="list-unstyled mt-3">
    <li class="mb-3">
   
   🛏️<strong>Medical Beds → </strong>Providing proper support and comfort to bedridden residents, ensuring they receive care with dignity.
    </li>
    <li class="mb-3">
     ♿<strong> Electronic Wheelchairs → </strong> Restoring mobility and independence to physically challenged individuals, allowing them to engage more freely in daily life.
    </li>
  </ul>
                </div>
                
                                <div class="col-lg-6 order-1 order-lg-2">
                    <div class="row g-2 image-gallery">
                        <div class="col-12">
                           <img
                                src="{{ asset('front') }}/images/csr/health-care.jpg"
                                alt="Tree Plantation Event"
                                class="img-fluid shadow-sm" />
                        </div>
                        
                      
                    </div>
                </div>

            </div>
            
            
            <!--Enhancing Medical Infrastructure for Street Animals, (Neighbourhood Woof)-->
            
            <div class="campaign-section row mt-5">
                <div class="col-lg-6 order-lg-1 order-2">
                    <div class="row g-2 image-gallery">
                        <div class="col-12">
                            <img
                                src="{{ asset('front') }}/images/csr/enhancing_medical.jpg"
                                alt="Tree Plantation Event"
                                class="img-fluid shadow-sm" />
                        </div>
                        
                    </div>
                </div>
                <div class="col-lg-6 order-lg-2 order-1">
                    <h3 class="csr-title">
                        Enhancing Medical Infrastructure for Street Animals, (Neighbourhood Woof)
                    </h3>
                    <p class="subheading">
                        At SMAS India, our vision for sustainability goes beyond human welfare—we are equally committed to the health and harmony of all sentient beings who share our environment. As part of this vision, we are proud to support Neighbourhood Woof, a pioneering animal welfare organization that has been revolutionizing street dog care in Delhi since its inception.
                    </p>
                    <p>
                        <i>About Neighbourhood Woof</i>
                        <br>
                        Founded with a mission to protect Delhi's most vulnerable residents, Neighbourhood Woof has:
                    </p>
                    <ul class="list-unstyled mt-3">
    <li class="mb-3">
  🐕 Provided critical medical care to thousands of street dogs annually
  </li>
    <li class="mb-3">
     🏥 Established sterilization and vaccination programs that benefit entire communities
    </li>
    <li class="mb-3">
     🚑 Created emergency response systems for injured and abused animals
    </li>
  </ul>
                    <p>
                        Their work embodies our shared values of compassion in action and sustainable community care.
                    </p>
                   
                   
                   <p>
                        <i>The Pawsitive Impact</i>
                        <br>
                        Through this collaboration, we're supporting diagnostic infrastructure that will:
                    </p>
                    <ul class="list-unstyled mt-3">
    <li class="mb-3">
  🔬 Enable life-saving pre-surgical screenings
  </li>
    <li class="mb-3">
    💉 Detect and prevent spread of contagious diseases
    </li>
    <li class="mb-3">
     🏥 Improve post-operative recovery monitoring
    </li>
    <li class="mb-3">
    👩⚕️ This initiative will directly enhance care for 3,000+ street dogs every year, ensuring they receive the dignity and medical attention they deserve.
    </li>
  </ul>
 <p>
                        <i>Why This Matters</i>
                        <br>
                        Our MD Hidenaga Aoki San recently met with Ms Ayesha from Neighbourhood Woof team, witnessing firsthand how:
                    </p>
                    <ul class="list-unstyled mt-3">
    <li class="mb-3">
 🌳 Animal welfare contributes to ecological balance
  </li>
    <li class="mb-3">
   ❤️ Compassionate care creates more humane communities
    </li>
    <li class="mb-3">
    🏙️ Healthy street dog populations mean healthier cities for all
    </li>
  
  </ul>
                </div>
            </div>
            
            
            <!--Therapeutic and Inclusive Growth for Children with Disabilities, (SAMADHAN)-->
            
             <div class="campaign-section row mt-5">
                
                <div class="col-lg-6 order-1 order-lg-1">
                    <h3 class="csr-title">
                        Therapeutic and Inclusive Growth for Children with Disabilities, (SAMADHAN)
                    </h3>
                    <p class="subheading">
                      At SMAS India, we believe every child deserves the right to dream, learn, and live to their fullest potential—regardless of developmental challenges. In this spirit, we are proud to collaborate with SAMADHAN, a Delhi-based organization making profound strides in the early intervention and rehabilitation of children with intellectual and developmental disabilities.
                    </p>
                    <p>
                       SAMADHAN’s holistic approach supports not just the child, but the entire family—offering therapy, education, and social integration to marginalized communities in South-West Delhi. Through this partnership, SMAS India has contributed to building specialized therapy infrastructure designed to create inclusive, sensory-rich environments.
                    </p>

                      <h5 class="mb-4">Key Contributions Include:</h5>
  <ul class="list-unstyled">
    <li class="mb-3">
      • <strong>A Therapy Garden</strong> equipped with sensory integration tools and motor skill development modules to encourage interactive play and cognitive growth.
    </li>
    <li class="mb-3">
      • <strong>A Greenhouse for ABA Therapy</strong> — a calming space for behavior-focused learning and professional intervention.
    </li>
    <li class="mb-3">
      • <strong>Accessibility Pathways</strong> that enable safe and smooth mobility for children and caregivers across the premises.
    </li>
  </ul>
  <p>With this initiative, over 100 children annually gain access to a nurturing space where they can build essential life skills—while their families receive hope, resources, and support. Therapists are now empowered to deliver more personalized and effective care.</p>
  
  <p>Our leadership team Mr. Hidenaga Aoki, Mr Rajesh Arora, Mr Sidharth Kaul & Mr Pankaj S Gurmukhani visited the facility to personally witness the warmth, determination, and transformation at the heart of SAMADHAN’s work. It reminded us that inclusive progress is not just about access—it’s about empowerment, empathy, and the structures we build to support every human story.</p>
  
  <p>Together, we are not just building infrastructure—we’re building futures.</p>
                </div>
                <div class="col-lg-6 order-2 order-lg-2">
                    <div class="row g-2 image-gallery">
                        <div class="col-12">
                            <img
                                src="{{ asset('front') }}/images/csr/therapeutic.jpg"
                                alt="Tree Plantation Event"
                                class="img-fluid shadow-sm" />
                        </div>
                        <div class="col-12">
                            <img
                                src="{{ asset('front') }}/images/csr/therapeutic2.jpg"
                                alt="Give Me Trees Trust Logo"
                                class="img-fluid shadow-sm" />
                        </div>
                      
                    </div>
                </div>
            </div
        </div>
    </section>



    <section id="section-collab" class="servicecollab">
        <div class="position-fix">
            <div class="bg"></div>
            <div class="bg bg2"></div>
            <div class="bg bg3"></div>
        </div>
        <div class="container-fluid">
            <div class="row align-items-center" id="collaborations">

                <div class="col-lg-12 col-12 serdetail">
                    <!-- <h2 class="mb-5 head1">CSR</h2> -->
                    <div class="row">
                        <div class="col-lg-12 col-12">
                            <!--<h3 class="display-5 fw-bold project-title">Coming Soon...</h3>-->
                            <h3 class="display-5 fw-bold project-title"> Stay tuned for more updates!</h3>
                        </div>

                    </div>


                </div>
            </div>
        </div>
    </section>


</div>
@endsection