<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="{{ asset('front') }}/images/jourrney_img_01.png" type="image/png" sizes="16x16">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Dashboard') - SMAS India</title>
     <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Animated Background */
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            z-index: -1;
            animation: gradientShift 15s ease infinite;
        }

        @keyframes gradientShift {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.8; }
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            height: 100vh;
            width: 260px;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border-right: 1px solid rgba(255, 255, 255, 0.2);
            padding: 30px 0;
            z-index: 1000;
            transition: transform 0.3s ease;
            animation: slideInLeft 0.6s ease;
        }

        @keyframes slideInLeft {
            from {
                transform: translateX(-100%);
            }
            to {
                transform: translateX(0);
            }
        }

        .sidebar-header {
            padding: 0 25px 30px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            margin-bottom: 20px;
        }

        .sidebar-header h2 {
            color: white;
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 5px;
        }

        .sidebar-header p {
            color: rgba(255, 255, 255, 0.7);
            font-size: 12px;
        }

        .sidebar-menu {
            list-style: none;
        }

        .sidebar-menu li {
            margin: 5px 0;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 15px 25px;
            color: rgba(255, 255, 255, 0.9);
            text-decoration: none;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .sidebar-menu a::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 4px;
            background: white;
            transform: scaleY(0);
            transition: transform 0.3s ease;
        }

        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background: rgba(255, 255, 255, 0.1);
            color: white;
        }

        .sidebar-menu a:hover::before,
        .sidebar-menu a.active::before {
            transform: scaleY(1);
        }

        .sidebar-menu .icon {
            margin-right: 15px;
            font-size: 20px;
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            padding: 30px;
            min-height: 100vh;
            animation: fadeIn 0.8s ease;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Top Navigation Bar */
        .top-navbar {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 15px;
            padding: 20px 30px;
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            animation: slideDown 0.6s ease;
        }

        @keyframes slideDown {
            from {
                transform: translateY(-50px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        .top-navbar h1 {
            color: white;
            font-size: 28px;
            font-weight: 700;
        }

        .logout-btn {
            background: rgba(220, 53, 69, 0.9);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: rgba(220, 53, 69, 1);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(220, 53, 69, 0.4);
        }

        /* Filter Form */
        .filter-form {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            padding: 25px;
            border-radius: 15px;
            margin-bottom: 25px;
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            align-items: flex-end;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            animation: scaleIn 0.5s ease 0.2s backwards;
        }

        @keyframes scaleIn {
            from {
                transform: scale(0.9);
                opacity: 0;
            }
            to {
                transform: scale(1);
                opacity: 1;
            }
        }

        .filter-form input[type="text"],
        .filter-form input[type="date"] {
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            flex-grow: 1;
            min-width: 150px;
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .filter-form input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .filter-form label {
            font-weight: 600;
            color: #555;
            display: block;
            margin-bottom: 5px;
            font-size: 13px;
        }

        .filter-form button,
        .filter-form a.reset-link {
            padding: 12px 20px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 14px;
        }

        .filter-form button {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
        }

        .filter-form button:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .filter-form a.reset-link {
            color: #555;
            text-decoration: none;
            border: 2px solid #e0e0e0;
            background-color: white;
            display: inline-block;
        }

        .filter-form a.reset-link:hover {
            border-color: #667eea;
            color: #667eea;
        }

        /* Action Links */
        .action-links {
            margin-bottom: 25px;
            animation: scaleIn 0.5s ease 0.3s backwards;
        }

        .action-links a {
            background: rgba(40, 167, 69, 0.9);
            color: white;
            padding: 12px 25px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-block;
        }

        .action-links a:hover {
            background: rgba(40, 167, 69, 1);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(40, 167, 69, 0.4);
        }

        /* Table Container */
        .table-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            animation: scaleIn 0.5s ease 0.4s backwards;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 15px 20px;
            text-align: left;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        }

        th {
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
            color: #495057;
            font-weight: 700;
            text-transform: uppercase;
            font-size: 12px;
            letter-spacing: 0.5px;
        }

        tbody tr {
            transition: all 0.3s ease;
            animation: slideUp 0.5s ease backwards;
        }

        tbody tr:nth-child(1) { animation-delay: 0.5s; }
        tbody tr:nth-child(2) { animation-delay: 0.55s; }
        tbody tr:nth-child(3) { animation-delay: 0.6s; }
        tbody tr:nth-child(4) { animation-delay: 0.65s; }
        tbody tr:nth-child(5) { animation-delay: 0.7s; }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        tbody tr:hover {
            background: rgba(102, 126, 234, 0.05);
            transform: scale(1.01);
        }

        tbody tr td a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        tbody tr td a:hover {
            color: #764ba2;
            text-decoration: underline;
        }

        /* Pagination */
        .pagination-container {
            margin-top: 25px;
            text-align: center;
            animation: fadeIn 0.8s ease 0.6s backwards;
        }

        /* Mobile Toggle */
        .mobile-toggle {
            display: none;
            position: fixed;
            top: 20px;
            left: 20px;
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            color: white;
            padding: 10px 15px;
            border-radius: 8px;
            cursor: pointer;
            z-index: 1001;
            font-size: 20px;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.active {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
                padding: 20px;
            }

            .mobile-toggle {
                display: block;
            }

            .top-navbar {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }

            .filter-form {
                flex-direction: column;
            }

            .table-container {
                overflow-x: auto;
            }
        }

        /* Loading Animation */
        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.5;
            }
        }
        
        
        
        
        
        
        
        
        
            
        
    /* Pagination Container */
.pagination-container {
    margin-top: 25px;
    text-align: center;
    animation: fadeIn 0.8s ease 0.6s backwards;
}

/* Pagination List */
.pagination {
    display: inline-flex;
    justify-content: center;
    align-items: center;
    gap: 6px;
    list-style: none;
    padding: 0;
    margin: 0;
}

/* Pagination Items */
.pagination .page-item {
    display: inline-block;
}

/* Pagination Links */
.pagination .page-link {
    display: inline-block;
    padding: 8px 14px;
    font-size: 14px;
    font-weight: 500;
    color: #007bff;
    background: #fff;
    border: 1px solid #ddd;
    border-radius: 6px;
    transition: all 0.3s ease;
    text-decoration: none;
}

/* Hover Effect */
.pagination .page-link:hover {
    background: #007bff;
    color: #fff;
    border-color: #007bff;
    text-decoration: none;
}

/* Active Page */
.pagination .page-item.active .page-link {
    background: #007bff;
    color: #fff;
    border-color: #007bff;
    cursor: default;
}

/* Disabled Buttons (e.g.  or  when not available) */
.pagination .page-item.disabled .page-link {
    color: #aaa;
    background: #f8f9fa;
    border-color: #ddd;
    cursor: not-allowed;
}

/* Hover Disabled Links - No Effect */
.pagination .page-item.disabled .page-link:hover {
    background: #f8f9fa;
    color: #aaa;
    border-color: #ddd;
}

/* Optional: Rounded Navigation Arrows */
.pagination .page-item:first-child .page-link,
.pagination .page-item:last-child .page-link {
    border-radius: 50%;
    width: 34px;
    height: 34px;
    line-height: 18px;
    text-align: center;
    font-size: 18px;
}

/* Optional Fade Animation */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}


@media (prefers-color-scheme: dark) {
    .pagination .page-link {
        background: #222;
        border-color: #444;
        color: #ccc;
    }
    .pagination .page-link:hover {
        background: #007bff;
        color: #fff;
        border-color: #007bff;
    }
    .pagination .page-item.active .page-link {
        background: #007bff;
        color: #fff;
        border-color: #007bff;
    }
}
    </style>

</head>
<body>
    <!-- Mobile Toggle -->
    <button class="mobile-toggle" onclick="toggleSidebar()">☰</button>

    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <h2>SMAS India</h2>
            <p>Admin Dashboard</p>
        </div>
        <ul class="sidebar-menu">
            <li>
                <a href="{{ route('dashboard') }}" class="{{ request()->routeIs('dashboard') ? 'active' : '' }}">
                    <span class="icon">📊</span>
                    <span>Dashboard</span>
                </a>
            </li>
        </ul>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Navbar -->
        <div class="top-navbar">
            <h1>@yield('page-title', 'Dashboard')</h1>
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button type="submit" class="logout-btn">Logout</button>
            </form>
        </div>

        <!-- Flash Messages -->
        @if(session('success'))
            <div class="alert alert-success" style="background: rgba(40, 167, 69, 0.1); border: 1px solid rgba(40, 167, 69, 0.3); padding: 15px; border-radius: 8px; margin-bottom: 20px; color: #155724;">
                {{ session('success') }}
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-error" style="background: rgba(220, 53, 69, 0.1); border: 1px solid rgba(220, 53, 69, 0.3); padding: 15px; border-radius: 8px; margin-bottom: 20px; color: #721c24;">
                {{ session('error') }}
            </div>
        @endif

        <!-- Page Content -->
        @yield('content')
    </div>
    <script nonce="{{ $csp_nonce }}">
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('active');
        }

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const toggle = document.querySelector('.mobile-toggle');
            
            if (window.innerWidth <= 768) {
                if (!sidebar.contains(event.target) && !toggle.contains(event.target)) {
                    sidebar.classList.remove('active');
                }
            }
        });
    </script>
</body>
</html>