@extends('Admin.layouts.master')

@section('title', 'Enquiries Dashboard')

@section('page-title', 'Enquiries Dashboard')

@section('styles')
<style>
    /* Filter Form */
    .filter-form {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border: 1px solid rgba(255, 255, 255, 0.3);
        padding: 25px;
        border-radius: 15px;
        margin-bottom: 25px;
        display: flex;
        flex-wrap: wrap;
        gap: 15px;
        align-items: flex-end;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        animation: scaleIn 0.5s ease 0.2s backwards;
    }

    @keyframes scaleIn {
        from {
            transform: scale(0.9);
            opacity: 0;
        }
        to {
            transform: scale(1);
            opacity: 1;
        }
    }

    .filter-form input[type="text"],
    .filter-form input[type="date"] {
        padding: 12px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        flex-grow: 1;
        min-width: 150px;
        font-size: 14px;
        transition: all 0.3s ease;
    }

    .filter-form input:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .filter-form label {
        font-weight: 600;
        color: #555;
        display: block;
        margin-bottom: 5px;
        font-size: 13px;
    }

    .filter-form button,
    .filter-form a.reset-link {
        padding: 12px 20px;
        border-radius: 8px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        font-size: 14px;
    }

    .filter-form button {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
    }

    .filter-form button:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
    }

    .filter-form a.reset-link {
        color: #555;
        text-decoration: none;
        border: 2px solid #e0e0e0;
        background-color: white;
        display: inline-block;
    }

    .filter-form a.reset-link:hover {
        border-color: #667eea;
        color: #667eea;
    }

    /* Action Links */
    .action-links {
        margin-bottom: 25px;
        animation: scaleIn 0.5s ease 0.3s backwards;
    }

    .action-links a {
        background: rgba(40, 167, 69, 0.9);
        color: white;
        padding: 12px 25px;
        border-radius: 8px;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
        display: inline-block;
    }

    .action-links a:hover {
        background: rgba(40, 167, 69, 1);
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(40, 167, 69, 0.4);
    }

    /* Table Container */
    .table-container {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border: 1px solid rgba(255, 255, 255, 0.3);
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        animation: scaleIn 0.5s ease 0.4s backwards;
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    th,
    td {
        padding: 15px 12px;
        text-align: left;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    }

    th {
        background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
        color: #495057;
        font-weight: 700;
        text-transform: uppercase;
        font-size: 12px;
        letter-spacing: 0.5px;
    }

    tbody tr {
        transition: all 0.3s ease;
        animation: slideUp 0.5s ease backwards;
    }

    tbody tr:nth-child(1) { animation-delay: 0.5s; }
    tbody tr:nth-child(2) { animation-delay: 0.55s; }
    tbody tr:nth-child(3) { animation-delay: 0.6s; }
    tbody tr:nth-child(4) { animation-delay: 0.65s; }
    tbody tr:nth-child(5) { animation-delay: 0.7s; }

    @keyframes slideUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    tbody tr:hover {
        background: rgba(102, 126, 234, 0.05);
        transform: scale(1.01);
    }

    tbody tr td a {
        color: #667eea;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    tbody tr td a:hover {
        color: #764ba2;
        text-decoration: underline;
    }





    @keyframes fadeIn {
        from {
            opacity: 0;
        }
        to {
            opacity: 1;
        }
    }

    @media (max-width: 768px) {
        .filter-form {
            flex-direction: column;
        }

        .table-container {
            overflow-x: auto;
        }
    }
    
    
        
    /* Pagination Container */
.pagination-container {
    margin-top: 25px;
    text-align: center;
    animation: fadeIn 0.8s ease 0.6s backwards;
}

/* Pagination List */
.pagination {
    display: inline-flex;
    justify-content: center;
    align-items: center;
    gap: 6px;
    list-style: none;
    padding: 0;
    margin: 0;
}

/* Pagination Items */
.pagination .page-item {
    display: inline-block;
}

/* Pagination Links */
.pagination .page-link {
    display: inline-block;
    padding: 8px 14px;
    font-size: 14px;
    font-weight: 500;
    color: #007bff;
    background: #fff;
    border: 1px solid #ddd;
    border-radius: 6px;
    transition: all 0.3s ease;
    text-decoration: none;
}

/* Hover Effect */
.pagination .page-link:hover {
    background: #007bff;
    color: #fff;
    border-color: #007bff;
    text-decoration: none;
}

/* Active Page */
.pagination .page-item.active .page-link {
    background: #007bff;
    color: #fff;
    border-color: #007bff;
    cursor: default;
}

/* Disabled Buttons (e.g. ‹ or › when not available) */
.pagination .page-item.disabled .page-link {
    color: #aaa;
    background: #f8f9fa;
    border-color: #ddd;
    cursor: not-allowed;
}

/* Hover Disabled Links - No Effect */
.pagination .page-item.disabled .page-link:hover {
    background: #f8f9fa;
    color: #aaa;
    border-color: #ddd;
}

/* Optional: Rounded Navigation Arrows */
.pagination .page-item:first-child .page-link,
.pagination .page-item:last-child .page-link {
    border-radius: 50%;
    width: 34px;
    height: 34px;
    line-height: 18px;
    text-align: center;
    font-size: 18px;
}

/* Optional Fade Animation */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}


@media (prefers-color-scheme: dark) {
    .pagination .page-link {
        background: #222;
        border-color: #444;
        color: #ccc;
    }
    .pagination .page-link:hover {
        background: #007bff;
        color: #fff;
        border-color: #007bff;
    }
    .pagination .page-item.active .page-link {
        background: #007bff;
        color: #fff;
        border-color: #007bff;
    }
}
</style>
@endsection

@section('content')
    <!-- Filter Form -->
    <form method="GET" action="{{ route('dashboard') }}" class="filter-form">
        <div style="flex-grow: 1; min-width: 200px;">
            <input type="text" name="search" placeholder="Search by Name, Email" value="{{ request('search') }}">
        </div>
        
        <div>
            <label>Start Date:</label>
            <input type="date" name="start_date" value="{{ request('start_date') }}">
        </div>
        
        <div>
            <label>End Date:</label>
            <input type="date" name="end_date" value="{{ request('end_date') }}">
        </div>
        
        <button type="submit">🔍 Filter</button>
        <a href="{{ route('dashboard') }}" class="reset-link">↻ Reset</a>
    </form>

    <!-- Action Links -->
    <div class="action-links">
        <a href="{{ route('enquiries.download', request()->query()) }}">
            📥 Download CSV
        </a>
    </div>

    <!-- Table -->
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>NO</th>
                    <th>Name</th>
                    <th>Lease Type</th>
                    <th>Company Name</th>
                    <th>Email</th>
                    <th>Reason of Contact</th>
                    <th>Mobile</th>
                    <th>Created At</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($enquiries as $enquiry)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $enquiry->first_name }} {{ $enquiry->last_name }}</td>
                        <td>{{ $enquiry->lease_type ?? 'N/A' }}</td>
                        <td>{{ $enquiry->company}}</td>
                        <td>{{ $enquiry->email }}</td>
                        <td>{{ $enquiry->webrequest_type }}</td>
                        <td>{{ $enquiry->mobile }}</td>
                        <td>
                            @php
                                $created = \Carbon\Carbon::parse($enquiry->created_at);
                                $now = \Carbon\Carbon::now();
                        
                                if ($created->isToday()) {
                                    $dateDisplay = 'Today, ' . $created->format('h:i A'); // 12-hour format with AM/PM
                                } elseif ($created->isYesterday()) {
                                    $dateDisplay = 'Yesterday, ' . $created->format('h:i A');
                                } else {
                                    $dateDisplay = $created->format('d M Y, h:i A'); // e.g. 13 Oct 2025, 03:45 PM
                                }
                            @endphp
                        
                            {{ $dateDisplay }}
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" style="text-align: center; padding: 30px; color: #666;">
                            No enquiries found matching the criteria.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="pagination-container">
        {{ $enquiries->appends(request()->query())->links() }}
    </div>
@endsection

