<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="{{ asset('front') }}/images/jourrney_img_01.png" type="image/png" sizes="16x16">
    <title>Enter OTP - SMAS India</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .otp-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            width: 100%;
            max-width: 450px;
        }

        .otp-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 40px 30px;
            text-align: center;
            color: white;
        }

        .otp-icon {
            width: 80px;
            height: 80px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 40px;
        }

        .otp-header h1 {
            font-size: 24px;
            margin-bottom: 10px;
            font-weight: 600;
        }

        .otp-header p {
            font-size: 14px;
            opacity: 0.9;
        }

        .otp-body {
            padding: 40px 30px;
        }

        .success-message {
            background: #d4edda;
            color: #155724;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
            border-left: 4px solid #28a745;
        }

        .error-message {
            background: #fee;
            color: #c33;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
            border-left: 4px solid #c33;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 500;
            font-size: 14px;
            text-align: center;
        }

        .otp-input-group {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-bottom: 20px;
        }

        .otp-input {
            width: 50px;
            height: 55px;
            text-align: center;
            font-size: 24px;
            font-weight: 600;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .otp-input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .btn-verify {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }

        .btn-verify:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
        }

        .btn-verify:active {
            transform: translateY(0);
        }

        .resend-text {
            text-align: center;
            margin-top: 20px;
            color: #666;
            font-size: 13px;
        }

        .resend-text a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }

        .resend-text a:hover {
            text-decoration: underline;
        }

        #otp-full {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 18px;
            text-align: center;
            letter-spacing: 5px;
            font-weight: 600;
        }
    </style>
</head>

<body>
    <div class="otp-container">
        <div class="otp-header">
            <div class="otp-icon">🔐</div>
            <h1>Enter OTP</h1>
            <p>We've sent a 6-digit code to your email</p>
        </div>

        <div class="otp-body">
            @if(session('success'))
            <div class="success-message">
                {{ session('success') }}
            </div>
            @endif

            @if($errors->any())
            <div class="error-message">
                @foreach($errors->all() as $error)
                {{ $error }}
                @endforeach
            </div>
            @endif

            <form action="{{ route('otp.process') }}" method="POST">
                @csrf

                <div class="form-group">
                    <label for="otp-full">Enter 6-Digit OTP</label>
                    <input type="text" id="otp-full" name="otp"
                        maxlength="6" placeholder="000000"
                        required autofocus>
                </div>

                <button type="submit" class="btn-verify">Verify OTP</button>
            </form>


<p style="margin-top: 20px; text-align: center;">
    <span>Did not receive the OTP?</span><br>

    <button id="resendBtn" type="button"
        style="background: none; border: none; color: gray; cursor: not-allowed; text-decoration: none;"
        disabled>
        Resend OTP (<span id="timer">--:--</span>)
    </button>
</p>

<div id="otpMessage" style="margin-top:10px; text-align:center;"></div>

<script nonce="{{ $csp_nonce }}" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script nonce="{{ $csp_nonce }}">
$(document).ready(function () {

    let remainingTime = {{ $remainingTime ?? 0 }};
    if (typeof remainingTime !== "number" || remainingTime < 0) remainingTime = 0;

    const timerDisplay = $('#timer');
    const resendBtn = $('#resendBtn');
    const messageBox = $('#otpMessage');
    

    function updateTimerDisplay(seconds) {
        let minutes = Math.floor(seconds / 60);
        let secs = seconds % 60;
        timerDisplay.text(`${minutes}:${secs.toString().padStart(2, '0')}`);
    }


    function enableResend() {
        resendBtn.prop('disabled', false)
                 .css({'cursor':'pointer','color':'#007bff','text-decoration':'underline'});
        timerDisplay.text('Now available');
    }


    function startCountdown(seconds) {
        remainingTime = seconds;
        resendBtn.prop('disabled', true)
                 .css({'cursor':'not-allowed','color':'gray','text-decoration':'none'});

        updateTimerDisplay(remainingTime);

        const countdown = setInterval(() => {
            remainingTime--;
            if (remainingTime > 0) {
                updateTimerDisplay(remainingTime);
            } else {
                clearInterval(countdown);
                enableResend();
            }
        }, 1000);
    }


    if (remainingTime > 0) {
        startCountdown(remainingTime);
    } else {
        enableResend();
    }


    resendBtn.click(function () {
        $.ajax({
            url: '{{ route("otp.resend") }}',
            method: 'POST',
            data: { _token: '{{ csrf_token() }}' },
            beforeSend: function() {
                resendBtn.prop('disabled', true);
                messageBox.html('Sending OTP...');
            },
            success: function(response) {
                startCountdown(120); // restart 2-minute countdown
                messageBox.html('<span style="color:green;">OTP sent successfully!</span>');
            },
            error: function(xhr) {
                let err = 'Could not resend OTP. Try again later.';
                if(xhr.responseJSON && xhr.responseJSON.error){
                    err = xhr.responseJSON.error;
                }
                messageBox.html('<span style="color:red;">'+err+'</span>');
                enableResend();
            }
        });
    });
});
</script>




            <div class="resend-text">
                Didn't receive code? <a href="{{ route('login') }}">Back to Login</a>
            </div>
        </div>
    </div>
</body>

</html>