<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->integer('category_id')->nullable();
            $table->integer('subcategory_id')->nullable();
            $table->integer('brand_id')->nullable();
            $table->string('product_name');
            $table->string('slug');
            $table->float('price');
            $table->float('discount_price');
            $table->integer('inventory')->nullable();
            $table->string('sku')->nullable();

            $table->string('product_image')->nullable();
            $table->string('product_image_alt_name')->nullable();
            $table->string('product_slider')->nullable();
            $table->string('product_slider_alt_name')->nullable();
            $table->string('product_detail_page_big_size_image1_desktop_view')->nullable();
            $table->string('product_detail_page_big_size_image1_desktop_view_alt_name')->nullable();
            $table->string('product_detail_page_big_size_image1_mobile_view')->nullable();
            $table->string('product_detail_page_big_size_image1_mobile_view_alt_name')->nullable();
            $table->string('product_detail_page_big_size_image2_desktop_view')->nullable();
            $table->string('product_detail_page_big_size_image2_desktop_view_alt_name')->nullable();
            $table->string('product_detail_page_big_size_image2_mobile_view')->nullable();
            $table->string('product_detail_page_big_size_image2_mobile_view_alt_name')->nullable();

            $table->string('title')->nullable();
            $table->longText('keywords')->nullable();
            $table->longText('description')->nullable();
            $table->tinyInteger('stock_status')->default(0);
            $table->tinyInteger('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
