<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Cookie;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Force HTTPS in local environment
        if (env('APP_ENV') === 'local') {
            URL::forceScheme('https');
        }

        // Bootstrap pagination with Bootstrap styles
        Paginator::useBootstrap();

        // Generate a nonce for CSP
        $nonce = bin2hex(random_bytes(16));
        View::share('csp_nonce', $nonce);

        // Host whitelist check
        // $allowedHosts = ['smasindia.com', 'www.smasindia.com'];
            
        $allowedHosts = [
            'smasindia.com',
            'www.smasindia.com',
            'smasindia.99isolutions.com',  
        ];
        
        $currentHost = request()->getHost();
        if (!in_array($currentHost, $allowedHosts)) {
            abort(403, 'Forbidden: Invalid Host');
        }
    }
}
