<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class SmasindiaLogin extends Authenticatable
{
    use Notifiable;

    protected $table = 'smasindia_logins';

    protected $fillable = [
        'username',
        'email',
        'password',
    ];

    protected $hidden = [
        'password',
    ];

    // Relationship to OTPs
    public function otps()
    {
        return $this->hasMany(OtpLogin::class, 'user_id');
    }
}