<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OtpLogin extends Model
{
    protected $table = 'smasindia_otp_logins';

    protected $fillable = [
        'user_id',
        'otp_login',
        'expire_at',
    ];

    // The 'expire_at' column should be a Carbon instance
    protected $dates = ['expire_at'];

    // Relationship to the User
    public function user()
    {
        return $this->belongsTo(SmasindiaLogin::class, 'user_id');
    }
}   