<?php

namespace App\Http\Controllers\front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use App\Models\Enquiry;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Http;

class HomeController extends Controller
{
    public function home()
    {

        return view('front.home');
    }
    public function compliance()
    {
      return view('front.compliance');
       
    }
    public function Services(){
        return view('front.services');
    }
    public function AboutUs(){
        return view('front.about-us');
    }
    public function GlobalCompany(){
        return view('front.global-company');
    }
    public function Events(){
        return view('front.events');
    }
    public function Collaboration(){
        return view('front.collaboration');
    }
    public function Csr(){
        return view('front.csr');
    }
    public function Others(){
        return view('front.others');
    }
    public function Faqs(){
        return view('front.faqs');
    }
    public function Blog(){
        return view('front.blog');
    }
    public function whySmasIndiaCarSubscriptionIsTheBestWayToGetYourDremCar(){
        return view('front.why-smas-india-car-subscription-is-the-best-way-to-get-your-dream-car');
    }
    public function HeresWhatIndustryInsidersSayAboutCarLeaseInIndia(){
        return view('front.heres-what-industry-insiders-say-about-car-lease-in-india');
    }
    public function GoingDigitalIsTheNewBlack(){
        return view('front.going-digital-is-the-new-black');
    }
    public function HowCanVehicleLeasingHelpYourBusinessOperateSmoothlyPostCovid(){
        return view('front.how-can-vehicle-leasing-help-your-business-operate-smoothly-post-covid');
    }
    public function howSmasIndiaDeliversTopNotchFleetManagementServiceAtYourDoorstep(){
        return view('front.how-smas-india-delivers-top-notch-fleet-management-service-at-your-doorstep');
    }
    public function QuestionsToAskYourFleetConsultancyServiceProvider(){
        return view('front.questions-to-ask-your-fleet-consultancy-service-provider');
    }
    public function LeasingRemedyToNavigateThroughMarketSlowdown(){
        return view('front.leasing-remedy-to-navigate-through-market-slowdown');
    }
    public function LeasingIndustryInIndiaWhatTodayTomorrowHolds(){
        return view('front.leasing-industry-in-india-what-today-tomorrow-holds');
    }
    public function Bs6ComplianceForVehiclesWhatCorporateFleetOwnersMustKnow(){
        return view('front.bs6-compliance-for-vehicles-what-corporate-fleet-owners-must-know');
    }
    public function WhyVehicleOwnershipCostsMoreToNewBusinessesAndWhatCanTheyDoAboutIt(){
        return view('front.why-vehicle-ownership-costs-more-to-new-businesses-and-what-can-they-do-about-it');
    }
    public function WhyNewBusinessesAreLeaningMoreMoreTowardsVehicleLeasingServices(){
        return view('front.why-new-businesses-are-leaning-more-more-towards-vehicle-leasing-services');
    }
    public function CanVehicleLeasingProfitaBusinessAndEnhanceItsEmployeeRetentionRate(){
        return view('front.can-vehicle-leasing-profit-a-business-and-enhance-its-employee-retention-rate');
    }
    public function HowToSelectaReliableVehicleLeasingPartnerInIndia(){
        return view('front.how-to-select-a-reliable-vehicle-leasing-partner-in-india');
    }

    public function BlogDetails(){
        return view('front.blog-details');
    }
    public function Contact(){
        return view('front.contact-us');
    }
    public function Careers(){
        return view('front.careers');
    }
    public function PrivacyPolicy(){
        return view('front.privacy-policy');
    }
    public function AntiPolicy(){
        return view('front.anti-policy');
    }
    public function InsuranceGrievanceRedressalProcedureRequestForm(){
        return view('front.insurance-grievance-redressal-procedure-request-form');
    }
    
    
    
    

    // public function sendEnquiry(Request $request)
    // {
    //     // Validation
    //     $request->validate([
    //         'lease_type'      => 'required|string',
    //         'first_name'      => 'required|alpha|max:40',
    //         'last_name'       => 'required|alpha|max:80',
    //         'email'           => 'required|email|max:80',
    //         'company'         => 'required|string|max:100',
    //         'mobile'          => 'required|digits_between:10,15',
    //         'webrequest_type' => 'required|string',
    //         'description'     => 'required|string',
    //         'privacy_policy'  => 'accepted',
    //         'captcha'         => 'required|digits:4',
    //     ]);
    
    //     // Prevent multiple leads within 24 hrs
    //     $errors = [];
    //     if (Enquiry::where('email', $request->email)->where('created_at', '>=', Carbon::now()->subDay())->exists()) {
    //         $errors['email'] = ['You can only submit one enquiry per email every 24 hours.'];
    //     }
    //     if (Enquiry::where('mobile', $request->mobile)->where('created_at', '>=', Carbon::now()->subDay())->exists()) {
    //         $errors['mobile'] = ['You can only submit one enquiry per mobile number every 24 hours.'];
    //     }
    //     if (!empty($errors)) {
    //         return response()->json(['status' => false, 'errors' => $errors], 422);
    //     }
    
    //     // Save Enquiry
    //     $enquiry = Enquiry::create([
    //         'lease_type'      => $request->lease_type,
    //         'first_name'      => $request->first_name,
    //         'last_name'       => $request->last_name,
    //         'email'           => $request->email,
    //         'company'         => $request->company,
    //         'mobile'          => $request->mobile,
    //         'webrequest_type' => $request->webrequest_type,
    //         'description'     => $request->description,
    //         'privacy_policy'  => $request->privacy_policy,
    //     ]);
    
    //     // Send Mail using Blade
    //     Mail::send('front.emails.enquiry', ['enquiry' => $enquiry], function ($msg) use ($enquiry) {
    //         $msg->to('irfankhanisolutions@gmail.com')
    //             ->subject("SMAS India: New Client Enquiry from {$enquiry->first_name} {$enquiry->last_name}");
    //     });

    
    //     return response()->json([
    //         'status'  => true,
    //         'message' => 'Your enquiry has been submitted successfully!'
    //     ]);
    // }




// public function sendEnquiry(Request $request)
// {
//     try {
//         // 1) Validation
//         $request->validate([
//             'lease_type'      => 'required|string',
//             'first_name'      => 'required|alpha|max:40',
//             'last_name'       => 'required|alpha|max:80',
//             'email'           => 'required|email|max:80',
//             'company'         => 'nullable|string|max:100',
//             'mobile'          => 'required|numeric|digits_between:10,15',
//             'webrequest_type' => 'required|string',
//             'description'     => 'required|string',
//             'privacy_policy'  => 'accepted',
//             'captcha'         => 'required|numeric',
//         ], [
//             'mobile.numeric' => 'Mobile must contain only numbers.',
//             'mobile.digits_between' => 'Mobile number must be between 10 and 15 digits.',
//             'captcha.required' => 'Captcha is required.',
//             'captcha.numeric'  => 'Captcha answer must be a number.',
//         ]);


//         // 2) Limit submit count per email/mobile per day (max 3)
//         $todayStart = Carbon::now()->startOfDay();
//         $todayEnd   = Carbon::now()->endOfDay();
//         $maxSubmissions = 3;

//         $emailCount = Enquiry::where('email', $request->email)
//             ->whereBetween('created_at', [$todayStart, $todayEnd])
//             ->count();

//         $mobileCount = Enquiry::where('mobile', $request->mobile)
//             ->whereBetween('created_at', [$todayStart, $todayEnd])
//             ->count();

//         if ($emailCount >= $maxSubmissions || $mobileCount >= $maxSubmissions) {
//             // return 422 with message - frontend will show this
//             return response()->json([
//                 'status' => false,
//                 'message' => "You have reached the maximum of {$maxSubmissions} submissions for today. Please try again tomorrow."
//             ], 422);
//         }

//         // 3) Save to DB (backup)
//         $enquiry = Enquiry::create($request->only([
//             'lease_type','first_name','last_name','email',
//             'company','mobile','webrequest_type','description','privacy_policy'
//         ]));

//         Log::info('sendEnquiry: Enquiry saved', ['id' => $enquiry->id]);

//         // 4) Send admin email (non-blocking for response; log errors)
//         try {
//             Mail::send('front.emails.enquiry', ['enquiry' => $enquiry], function ($msg) use ($enquiry) {
//                 $msg->to('irfankhanisolutions@gmail.com')
//                     ->subject("SMAS India: New Client Enquiry from {$enquiry->first_name} {$enquiry->last_name}");
//             });
//             Log::info('sendEnquiry: Admin email sent', ['to' => 'irfankhanisolutions@gmail.com']);
//         } catch (\Exception $e) {
//             Log::error('sendEnquiry: Admin email failed', ['error' => $e->getMessage()]);
//             // Optionally: email businessplanning@smasindia.com about failure — you can add here.
//         }

//         // 5) Build dynamic message for Thank You page
//         $userFullName = $enquiry->first_name . ' ' . $enquiry->last_name;
//         $userMessage = match($enquiry->webrequest_type) {
//             'Enquiry'  => "Dear {$userFullName},\n\nThank you for your Enquiry.\nOur team is reviewing your message and will contact you soon.\nIf your enquiry is urgent, please connect with us at reach_us@smasindia.com or +91-11-4828-8300\n\nThank you,\nThe SMAS India Team",
//             'Feedback' => "Dear {$userFullName},\n\nThank you for your valuable feedback.\nThis will help us serve you better.\n\nSincerely,\nThe SMAS India Team",
//             'Complaint'=> "Dear {$userFullName},\n\nSad to learn we couldn't meet your expectations.\nWe take all complaints seriously and are committed to making this right for you. Our team is reviewing your message and will contact you soon for a resolution.\n\nSincerely,\nThe SMAS India Team",
//             default    => "Dear {$userFullName},\n\nThank you for contacting SMAS India. Our team will review your message and respond accordingly.\n\nSincerely,\nThe SMAS India Team",
//         };

//         // 6) store the userMessage in session for the next request (thank you page)
//         session()->put('userMessage', $userMessage);
        

//         // 7) return JSON success with redirect target (AJAX will redirect the browser)
//         return response()->json([
//             'status'   => true,
//             'redirect' => route('home.thank_you')
//         ]);

//     } catch (ValidationException $e) {
//         // forward validation errors to frontend (422)
//         return response()->json(['status' => false, 'errors' => $e->errors()], 422);
//     } catch (\Exception $e) {
//         Log::error('sendEnquiry: Exception', ['error' => $e->getMessage()]);
//         return response()->json(['status' => false, 'message' => 'Something went wrong. Please try again.'], 500);
//     }
// }


    public function sendEnquiry(Request $request)
    {
        try {
            // 1) Validation
            $request->validate([
                'lease_type'      => 'required|string',
                'first_name'      => 'required|alpha|max:40',
                'last_name'       => 'required|alpha|max:80',
                'email'           => 'required|email|max:80',
                'company'         => 'nullable|string|max:100',
                'mobile'          => 'required|numeric|digits_between:10,15',
                'webrequest_type' => 'required|string',
                'description'     => 'required|string',
                'privacy_policy'  => 'accepted',
                'captcha'         => 'required|numeric',
            ], [
                'mobile.numeric' => 'Mobile must contain only numbers.',
                'mobile.digits_between' => 'Mobile number must be between 10 and 15 digits.',
                'captcha.required' => 'Captcha is required.',
                'captcha.numeric'  => 'Captcha answer must be a number.',
            ]);

            // 2) Limit submit count per email/mobile per day (max 3)
            $todayStart = Carbon::now()->startOfDay();
            $todayEnd   = Carbon::now()->endOfDay();
            $maxSubmissions = 3;

            $emailCount = Enquiry::where('email', $request->email)
                ->whereBetween('created_at', [$todayStart, $todayEnd])
                ->count();

            $mobileCount = Enquiry::where('mobile', $request->mobile)
                ->whereBetween('created_at', [$todayStart, $todayEnd])
                ->count();

            if ($emailCount >= $maxSubmissions || $mobileCount >= $maxSubmissions) {
                // return 422 with message - frontend will show this
                return response()->json([
                    'status' => false,
                    'message' => "You have reached the maximum of {$maxSubmissions} submissions for today. Please try again tomorrow."
                ], 422);
            }

            // 3) Save to DB
            $enquiry = Enquiry::create($request->only([
                'lease_type','first_name','last_name','email',
                'company','mobile','webrequest_type','description','privacy_policy'
            ]));

            Log::info('sendEnquiry: Enquiry saved', ['id' => $enquiry->id]);

            // 4) Send admin email (Blade)
            try {
                Mail::send('front.emails.enquiry', ['enquiry' => $enquiry], function ($msg) use ($enquiry) {
                    $msg->to('irfankhanisolutions@gmail.com')
                        ->subject("SMAS India: New Client Enquiry from {$enquiry->first_name} {$enquiry->last_name}");
                });
                Log::info('sendEnquiry: Admin email sent', ['to' => 'irfankhanisolutions@gmail.com']);
            } catch (\Exception $e) {
                Log::error('sendEnquiry: Admin email failed', ['error' => $e->getMessage()]);
            }
            
        
            // 5) Push to Salesforce Web-to-Lead
            try {
                $url = config('app.salesforce.webtolead_url');
            
                if (!$url) {
                    Log::error('Salesforce Web-to-Lead URL missing. Check config/app.php');
                } else {
                    $sfData = [
                        'oid'        => config('app.salesforce.oid'),
                        'retURL'     => config('app.salesforce.returl'),
                        'first_name' => $enquiry->first_name,
                        'last_name'  => $enquiry->last_name,
                        'email'      => $enquiry->email,
                        'company'    => $enquiry->company,
                        'mobile'     => $enquiry->mobile,
                        'description'=> $enquiry->description,
            
                        // custom field mappings
                        '00N6F00000Y0seH' => $enquiry->lease_type,
                        '00NTZ000001fYTO' => $enquiry->webrequest_type,
                        '00NTZ000001fZ7h' => $enquiry->privacy_policy ? '1' : '0',
                    ];
            
                    $sfResponse = Http::asForm()->post($url, $sfData);
            
                    Log::info('sendEnquiry: Salesforce response', [
                        'status' => $sfResponse->status(),
                        'body'   => substr($sfResponse->body(), 0, 500)
                    ]);
                }
            } catch (\Exception $ex) {
                Log::error('sendEnquiry: Salesforce push failed', [
                    'error' => $ex->getMessage()
                ]);
            }


            // 6) Build dynamic message for Thank You page
            $userFullName = $enquiry->first_name . ' ' . $enquiry->last_name;
            $userMessage = match($enquiry->webrequest_type) {
                'Enquiry'  => "Dear {$userFullName},\n\nThank you for your Enquiry.\nOur team is reviewing your message and will contact you soon.\nIf your enquiry is urgent, please connect with us at reach_us@smasindia.com or +91-11-4828-8300\n\nThank you,\nThe SMAS India Team",
                'Feedback' => "Dear {$userFullName},\n\nThank you for your valuable feedback.\nThis will help us serve you better.\n\nSincerely,\nThe SMAS India Team",
                'Complaint'=> "Dear {$userFullName},\n\nSad to learn we couldn't meet your expectations.\nWe take all complaints seriously and are committed to making this right for you. Our team is reviewing your message and will contact you soon for a resolution.\n\nSincerely,\nThe SMAS India Team",
                default    => "Dear {$userFullName},\n\nThank you for contacting SMAS India. Our team will review your message and respond accordingly.\n\nSincerely,\nThe SMAS India Team",
            };

            // 7) Persist userMessage in session (permanent until cleared)
            session()->put('userMessage', $userMessage);

            // 8) JSON success with redirect
            return response()->json([
                'status'   => true,
                'redirect' => route('home.thank_you')
            ]);
        } catch (ValidationException $e) {
            return response()->json(['status' => false, 'errors' => $e->errors()], 422);
        } catch (\Exception $e) {
            Log::error('sendEnquiry: Exception', ['error' => $e->getMessage()]);
            return response()->json(['status' => false, 'message' => 'Something went wrong. Please try again.'], 500);
        }
    }




    public function sendToSalesforce($data)
    {
        $curl = curl_init();
    
        // Map the data to the Salesforce Web-to-Lead format
        $postFields = [
            'encoding' => 'UTF-8',
            'orgId' => '00D6F000002RRZl', // Salesforce Org ID
            'oid' => '00D6F000002RRZl', // Salesforce OID
            'retURL' => 'https://www.smasindia.com/', // Redirect URL
            'first_name' => $data['name'], // Mapping 'name' from data
            'last_name' => '', // Mapping 'c_name' from data
            'email' => $data['email'], // Mapping 'email' from data
            'company' => $data['c_name'] ?? '', // You can optionally pass a company field from $data
            'mobile' => $data['phone'], // Mapping 'phone' from data
            '00N6F00000Y0seH' => $data['enquiry_type'], // Custom field from data
            'description' => $data['message'], // Mapping 'message' from data
        ];
    
        // Prepare cURL request
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://webto.salesforce.com/servlet/servlet.WebToLead',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => http_build_query($postFields), // Use http_build_query to format the data
            CURLOPT_HTTPHEADER => [
                'Cookie: BrowserId=dDgQUayvEe-E-ZEYUavHvg'
            ],
        ]);
    
        // Execute the request
        $response = curl_exec($curl);
    
        // Close the cURL session
        curl_close($curl);
    
        // You can log the response or handle it as needed
        // dd($response);
        return $response;
    }



      public function searchRedirect(Request $request)
        {
            $query = strtolower($request->input('query')); // User's search query
    
            // Define static pages with keywords
    $pages = [
        ['url' => route('home'), 'keywords' => ['home', 'welcome', 'main']],
        ['url' => route('home.services'), 'keywords' => ['services', 'offerings']],
        ['url' => route('home.aboutus'), 'keywords' => ['about us', 'company', 'info']],
        ['url' => route('home.contact'), 'keywords' => ['contact', 'support', 'help']],
        ['url' => route('home.careers'), 'keywords' => ['careers', 'jobs', 'vacancies']],
        ['url' => route('home.blog'), 'keywords' => ['blog', 'articles', 'news']],
        ['url' => route('home.services') . '#vehicle-leasing', 'keywords' => ['Vehicle Leasing', 'Leasing']],
        ['url' => route('home.services') . '#fleet-management', 'keywords' => ['Fleet Management Services', 'Fleet Management', 'Management Services']],
        ['url' => route('home.services') . '#value-added', 'keywords' => ['Value Added Services', 'Value Services']],
    ];
    
    
            // Match query with keywords
            $matchedPage = collect($pages)->first(function ($page) use ($query) {
                return collect($page['keywords'])->contains(function ($keyword) use ($query) {
                    return str_contains($keyword, $query);
                });
            });
    
            // Redirect if match found, otherwise show "No Results"
            if ($matchedPage) {
                return redirect($matchedPage['url']);
            }
    
            return redirect()->route('home')->with('error', 'No matching page found for your search.');
        }


    public function RedressalProcedureForm(Request $request)
    {
        // Validate the request
        $request->validate([
            'name' => 'required',
            'phone' => 'required',
            'email' => 'required|email',
            'car_number' => 'required',
            'grievance_datails' => 'required',
            'privacy_policy' => 'required',
            //  'file' => 'required|mimes:pdf,jpg,png',  // file validation
            'file' => 'required'
        ]);

        // Handle file upload
        $filePath = null;
        $fileData = null;
    
        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $fileName = time() . '_' . $file->getClientOriginalName();
            $filePath = $file->storeAs('uploads/enquiries', $fileName, 'public');
            // $fileData = curl_file_create($file->getPathname(), $file->getMimeType(), $fileName);

            $fileName = asset('/storage/' . $filePath);
        }
        // dd($fileData);


        // Prepare dynamic data for the cURL request
        $postData = [
            'name' => $request->input('name'),
            'phone' => $request->input('phone'),
            'email' => $request->input('email'),
            'car_number' => $request->input('car_number'),
            'grievance_datails' => $request->input('grievance_datails'),
            'privacy_policy' => $request->input('privacy_policy'),
            'file' => $fileName, // Attach the uploaded file
        ];

        // Initialize cURL
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://smasindia.aks.5g.in/api/redressal-procedure-enquiry',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $postData, // Pass dynamic data
        ]);

        // Execute the cURL request
        $response = curl_exec($curl);

        // Close cURL
        curl_close($curl);
        // dd($response);

        return response()->json(['status' => 'true', 'message' => 'Insurance Grievance Redressal Procedure Form Submited successfully!', 'response' => $response]);
    }

    // public function RedressalProcedureForm(Request $request)
    //     {
    //         dd($request->all());
    //         $request->validate([
    //             'name' => 'required',
    //             'phone' => 'required',
    //             'email' => 'required|email',
    //             'car_number' => 'required',
    //             'grievance_datails' => 'required',
    //             'privacy_policy' => 'required',
    //             'file' => 'required|mimes:pdf,jpg,png|max:2048',
    //         ]);
    
    //         // Handle file upload
    //         $filePath = null;
    //         if ($request->hasFile('file')) {
    //             $file = $request->file('file');
    //             $filePath = $file->store('uploads/enquiries', 'public'); // Store file in the 'public/uploads/enquiries' directory
    //         }
            
    
    //         $enquiryredressalProced = $request->only(['name', 'phone', 'email', 'car_number', 'grievance_datails', 'privacy_policy', 'message']);
    
    //         // Send the email
    //         // dd($filePath);
    //         Mail::to('reach_us@smasindia.com')->send(new EnquiryRedressalProcedureMail($enquiryredressalProced, $filePath));
    
    //         // return back()->with('success', 'Enquiry sent successfully!');
    //         return response()->json(['status' => 'true', 'message' => 'Enquiry Sent successfully!']);
    //     }


    public function ThankYou(){
        return view('front.thank-you');
    }
    

    
    
    public function Sitemap()
    {
        $now = Carbon::now()->toAtomString();

        $urls = [
            ['loc' => url('/'), 'priority' => '1.00'],
            ['loc' => url('/services'), 'priority' => '0.80'],
            ['loc' => url('/about-us'), 'priority' => '0.80'],
            ['loc' => url('/global-company'), 'priority' => '0.80'],
            ['loc' => url('/news-release/events'), 'priority' => '0.80'],
            ['loc' => url('/news-release/collaborations'), 'priority' => '0.80'],
            ['loc' => url('/news-release/csr'), 'priority' => '0.80'],
            ['loc' => url('/others'), 'priority' => '0.80'],
            ['loc' => url('/faqs'), 'priority' => '0.80'],
            ['loc' => url('/blog'), 'priority' => '0.80'],
            ['loc' => url('/contact'), 'priority' => '0.80'],
            ['loc' => url('/anti-policy'), 'priority' => '0.80'],
            ['loc' => url('/careers'), 'priority' => '0.80'],
            ['loc' => url('/privacy-policy'), 'priority' => '0.80'],
            ['loc' => url('/front/pdf/term-of-service.pdf'), 'priority' => '0.80'],
            ['loc' => url('/insurance-grievance-redressal-procedure-request-form'), 'priority' => '0.64'],
            ['loc' => url('/front/images/csr/SMAS%20Auto%20Leasing%20India%20CSR%20Policy%202025%2003.04.2025.pdf'), 'priority' => '0.64'],
            ['loc' => url('/why-smas-india-car-subscription-is-the-best-way-to-get-your-dream-car'), 'priority' => '0.64'],
            ['loc' => url('/heres-what-industry-insiders-say-about-car-lease-in-india'), 'priority' => '0.64'],
            ['loc' => url('/going-digital-is-the-new-black'), 'priority' => '0.64'],
            ['loc' => url('/how-can-vehicle-leasing-help-your-business-operate-smoothly-post-covid-19'), 'priority' => '0.64'],
            ['loc' => url('/how-smas-india-delivers-top-notch-fleet-management-service-at-your-doorstep'), 'priority' => '0.64'],
            ['loc' => url('/4-questions-to-ask-your-fleet-consultancy-service-provider'), 'priority' => '0.64'],
            ['loc' => url('/leasing-remedy-to-navigate-through-market-slowdown'), 'priority' => '0.64'],
            ['loc' => url('/leasing-industry-in-india-what-today-tomorrow-holds'), 'priority' => '0.64'],
            ['loc' => url('/bs6-compliance-for-vehicles-what-corporate-fleet-owners-must-know'), 'priority' => '0.64'],
            ['loc' => url('/why-vehicle-ownership-costs-more-to-new-businesses-and-what-can-they-do-about-it'), 'priority' => '0.64'],
            ['loc' => url('/why-new-businesses-are-leaning-more-more-towards-vehicle-leasing-services'), 'priority' => '0.64'],
            ['loc' => url('/can-vehicle-leasing-profit-a-business-and-enhance-its-employee-retention-rate'), 'priority' => '0.64'],
            ['loc' => url('/how-to-select-a-reliable-vehicle-leasing-partner-in-india'), 'priority' => '0.64'],
            ['loc' => url('/front/pdf/Money-Laundring-Policy-SMAS-India-%20final.pdf'), 'priority' => '0.64'],
            ['loc' => url('/front/pdf/Whistle%20Blower%20policy%20-%20SMAS%20India.pdf'), 'priority' => '0.64'],
            ['loc' => url('/front/pdf/Draft_Form_MGT_7_2022.pdf'), 'priority' => '0.64'],
            ['loc' => url('/front/pdf/Grievance%20Redressal%20Procedure.pdf'), 'priority' => '0.51'],
        ];

        return response()->view('front.sitemap', compact('urls', 'now'))
                         ->header('Content-Type', 'application/xml');
    }
    
    
    


    
    
  }
