<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Enquiry;
use Illuminate\Support\Facades\Response;

class DashboardController extends Controller
{


  public function index(Request $request)
    {
        $query = Enquiry::query();

        // 1. Search Filter (Updated for first_name, last_name, or email)
        if ($search = $request->input('search')) {
            $query->where(function ($q) use ($search) {
                $q->where('first_name', 'like', "%{$search}%")
                  ->orWhere('last_name', 'like', "%{$search}%")
                  ->orWhere('email', 'like', "%{$search}%");
            });
        }

        // 2. Date Range Filter
        if ($startDate = $request->input('start_date')) {
            $query->whereDate('created_at', '>=', $startDate);
        }
        if ($endDate = $request->input('end_date')) {
            $query->whereDate('created_at', '<=', $endDate);
        }

        // 3. Pagination
        $enquiries = $query->latest()->paginate(3)->withQueryString();

        return view('Admin.dashboard.enquiries', compact('enquiries'));
    }

    // CSV Download (Updated to include all new columns)
    public function downloadEnquiries(Request $request)
    {
        // Apply filters to the download data as well
        $query = Enquiry::query();
        // ... (Repeat the search and date filter logic from the 'enquiries' method here if needed) ...
        $enquiries = $query->latest()->get();

        $fileName = 'smasindia_enquiries_' . now()->format('Ymd_His') . '.csv';

        $headers = [
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        ];

        // ALL COLUMNS FROM THE UPDATED MODEL
        $columns = [
            'ID', 'Lease Type', 'First Name', 'Last Name', 'Email', 
            'Company', 'Mobile', 'Web Request Type', 'Description', 
            'Privacy Policy', 'Created At'
        ];

        $callback = function() use ($enquiries, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($enquiries as $enquiry) {
                fputcsv($file, [
                    $enquiry->id,
                    $enquiry->lease_type,
                    $enquiry->first_name,
                    $enquiry->last_name,
                    $enquiry->email,
                    $enquiry->company,
                    $enquiry->mobile,
                    $enquiry->webrequest_type,
                    $enquiry->description,
                    $enquiry->privacy_policy ? 'Yes' : 'No', // Format boolean field
                    $enquiry->created_at,
                ]);
            }
            fclose($file);
        };

        return Response::stream($callback, 200, $headers);
    }
}