@extends('front.layouts.masterhome')
@section('meta_title', 'Insurance Grievance Redressal Form | SMAS India')
@section('meta_description', 'Submit your insurance-related grievance with ease. Use our redressal form to ensure prompt, transparent resolution by SMAS India.')
@section('section')
<div class="no-bottom no-top" id="content">
    <div id="top"></div>

    <!-- section begin -->
    <section id="subheader" class="jarallax text-light">
        <img src="{{ asset('front') }}/images/background/insu-banner1.jpg" class="jarallax-img" alt="Insurance">
        <div class="center-y relative text-center">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 text-center">
                        <h1 class="fs-1">Insurance Grievance Redressal Procedure Request Form</h1>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>
    <!-- section close -->

    <!-- services section start -->
    <div class="insurance-g my-3" id="section-insurance">
        <div class="container-fluid">
            <div class="row text-center">
                <div class="col-lg-12 col-12">
                    <img src="{{ asset('front') }}/./images/f2.jpg" alt="Insurance Claim Form" class="img-fluid">

                </div>
            </div>
        </div>
    </div>
    <!-- services section end -->

    <!-- services content section start -->
    <section id="section-cars" class="servicecont insurancef">
        <div class="position-fix">
            <div class="bg"></div>
            <div class="bg bg2"></div>
            <div class="bg bg3"></div>
        </div>
        <div class="container-fluid">

            <div class="row gx-5 insurance-form">
                <div class="col-lg-12 col-12 serdetail">
                    <div class="row align-items-center">
                        <h3 class="mb-5 head1">Insurance Grievance Redressal Procedure Request Form</h3>
                         <form class="row g-3" action="{{ route('home.redressal_procedure_form') }}" method="POST" id="redressal_procedure_form" enctype="multipart/form-data" data-parsley-validate>
                            @csrf
                            <div class="col-md-6 col-12">
                                <label for="username" class="form-label">Policy Holder's / Car User's
                                    Name*</label>
                               <input type="text" class="form-control is-valid" id="username" name="name"
                                    placeholder="Policy Holder's / Car User's Name" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label for="mobile" class="form-label">Mobile Number*</label>
                                 <input type="text" class="form-control is-valid" id="mobile" name="phone"
                                    placeholder="Mobile Number" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label for="email" class="form-label">E-mail ID*</label>
                                 <input type="email" class="form-control is-valid" id="email" name="email"
                                    placeholder="E-mail ID" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label for="carnum" class="form-label">Car Number*</label>
                                  <input type="text" class="form-control is-valid" id="carnum" name="car_number"
                                    placeholder="Car Number" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label for="upload" class="form-label">Upload Policy*</label>
                                <input type="file" class="form-control is-invalid" id="upload" name="file"
                                    aria-describedby="uploadFeedback"
                                    accept="application/pdf, image/jpg, image/png" required>
                                <div id="uploadFeedback" class="invalid-feedback text-black">Note:
                                    only pdf, jpg, png files with max size of 2MB are permitted.</div>
                            </div>
                            <div class="col-md-6 col-12">
                                <label for="details" class="form-label gd">Grievance Details*</label>
                                <textarea class="form-control" id="details" placeholder="Grievance Details" name="grievance_datails" required></textarea>

                            </div>
                            <p class="mb-0">
                                <span style="color: #000;">Click here to view our <a
                                        href="{{ asset('front') }}/./pdf/Grievance Redressal Procedure.pdf" target="_blank"
                                        class="grievances"><strong>Insurance Grievance Redressal
                                            Procedure</strong></a>
                                </span>
                            </p>
                            <div class="col-12">
                                <div class="form-check">
                                     <input class="form-check-input is-invalid" type="checkbox" name="privacy_policy" value="agree"
                                        id="invalidCheck3" aria-describedby="invalidCheck3Feedback" required>
                                    <label class="form-check-label text-black" for="invalidCheck3">I agree
                                        to <a href="{{ route('home.privacy_policy') }}" target="_blank"><strong>Privacy
                                                Policy</strong></a> and <a href="{{ asset('front') }}/./pdf/term-of-service.pdf"
                                            target="_blank"><strong>Terms &amp;
                                                Conditions</strong></a>.</label>
                                </div>
                            </div>
                            <div class="col-12 mt-3">
                                <button class="btn btn-primary" type="button" onclick="RedressalProcedureform()">Submit form</button>
                            </div>
                        </form>



                    </div>

                </div>
            </div>
        </div>
    </section>
    <!-- services content section start -->


</div>



<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function RedressalProcedureform() {

        $('.text-danger').text('');

        // Validate the form using Parsley
        var isValid = $('#redressal_procedure_form').parsley().validate();

        // If form validation fails, return
        if (!isValid) {
            return;
        }
        
         const fileInput = document.getElementById("upload");
         const file = fileInput.files[0]; // Selected file
         const allowedFormats = ["application/pdf", "image/jpg", "image/jpeg", "image/png"];
         const maxSize = 2 * 1024 * 1024; // 2MB in bytes
         if (!file) {
           alert("Please upload a file.");
           return;
         }
         if (!allowedFormats.includes(file.type)) {
            alert("Only PDF, JPG, and PNG files are allowed.");
            fileInput.value = ""; // Reset file input
           return;
         }
         if (file.size > maxSize) {
           alert("File size should not exceed 2MB.");
           fileInput.value = ""; // Reset file input
           return;
         }



        Swal.fire({
            title: 'Please wait...',
            allowOutsideClick: false,
            showConfirmButton: false,
            willOpen: () => {
                Swal.showLoading()
            }
        });
        var action = $('#redressal_procedure_form').attr('action');
        var formData = new FormData($('#redressal_procedure_form')[0]); // 'this' refers to the form being submitted
        $.ajax({
            type: "post",
            url: action,
            data: formData,
            processData: false,
            contentType: false,
            success: function(data) {
                // Handle successful response (if needed)
                if (data.status === 'true') {
                    // Show an alert for successful registration
                    Swal.close();

                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: data.message,
                    }).then(function() {
                        // Redirect to a URL
                        window.location.reload();
                    });

                    // You can also redirect the user or perform other actions here
                }
            },
            error: function(xhr) {
                // Handle errors
                Swal.close();
                var errors = xhr.responseJSON.errors;
                $.each(errors, function(key, value) {
                    // Display errors
                    // For example, you can add an element with ID 'error-' + key to display errors next to the corresponding input field
                    $('#error-' + key).text(value[0]);

                    toastr.options = {
                        "closeButton": true,
                        "progressBar": true
                    }
                    toastr.error(value[0]);

                });
            }
        });

    }
</script>
@endsection