  @extends('front.layouts.masterhome')
  @section('meta_title', 'FAQs - Vehicle Leasing Services | SMAS India')
  @section('meta_description', 'Find answers to common questions about vehicle leasing services with SMAS India. Explore
  our FAQ section for detailed information and assistance.')


  @section('section')

  <div class="no-bottom no-top" id="content">
    <div id="top"></div>

    <!-- section begin -->
    <section id="subheader" class="jarallax text-light">
      <img src="{{ asset('front') }}/images/background/faqs-banner.jpg" class="jarallax-img" alt="Vehicle Service and Maintenance
">
      <div class="center-y relative text-center">
        <div class="container">
          <div class="row">
            <div class="col-md-12 text-center">
              <h1>FAQs</h1>
            </div>
            <div class="clearfix"></div>
          </div>
        </div>
      </div>
    </section>
    <!-- section close -->

    <section id="section-hero fqs-section" aria-label="section" class="blog_section">
      <div class="container">
        <div class="row">
          <div class="col-lg-12 col-12 pb-5">
            <h2 class="fqs">Frequently Asked Questions</h2>
          </div>
        </div>
      </div>

      <div class="container ">
        <div class="row gx-5">
          <div class="col-lg-12 col-md-12">
            <div class="row">
              <div class="faq-accor">
                <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                  <button class="nav-link active" id="v-pills-home-tab" data-bs-toggle="pill"
                    data-bs-target="#v-pills-home" type="button" role="tab" aria-controls="v-pills-home"
                    aria-selected="true">General
                  </button>

                  <button class="nav-link" id="v-pills-introduction-tab" data-bs-toggle="pill"
                    data-bs-target="#v-pills-introduction" type="button" role="tab" aria-controls="v-pills-introduction"
                    aria-selected="false">Introduction
                  </button>

                  <button class="nav-link" id="v-pills-lease-tab" data-bs-toggle="pill" data-bs-target="#v-pills-lease"
                    type="button" role="tab" aria-controls="v-pills-lease" aria-selected="false">Lease Fees
                  </button>


                  <div class="dropdown d-inline-flex align-items-center">
                    <!-- Main button (does not toggle dropdown) -->

                    <button class="nav-link" id="v-pills-service-tab" data-bs-toggle="pill"
                      data-bs-target="#v-pills-service" type="button" role="tab"
                      aria-controls="v-pills-service" aria-selected="false" style="position:relative">FLEET MANAGEMENT SERVICES (FMS)

                    </button>

                    <!-- Arrow button (dropdown toggle) -->
                    <button
                      class="btn btn-primary dropdown-toggle dropdown-toggle-split" style="position: absolute;right: 0;background: transparent;box-shadow: none;"
                      type="button"
                      data-bs-toggle="dropdown"
                      aria-expanded="false"
                      aria-label="Toggle Dropdown">
                      <span class="visually-hidden">Toggle Dropdown</span>
                    </button>

                    <!-- Dropdown menu -->
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="#" id="v-pills-maintenance-tab" data-bs-toggle="pill" data-bs-target="#v-pills-maintenance">Maintenance</a></li>
                      <li><a class="dropdown-item" href="#" id="v-pills-tyres-tab" data-bs-toggle="pill" data-bs-target="#v-pills-tyres">Tyres & Batteries</a></li>
                      <li><a class="dropdown-item" href="#" id="v-pills-adw-tab" data-bs-toggle="pill" data-bs-target="#v-pills-adw">Accident Depreciation Waiver (ADW)</a></li>
                      <li><a class="dropdown-item" href="#" id="v-pills-replacement-tab" data-bs-toggle="pill" data-bs-target="#v-pills-replacement">Quick Replacement Car</a></li>
                      <li><a class="dropdown-item" href="#" id="v-pills-pickup-tab" data-bs-toggle="pill" data-bs-target="#v-pills-pickup">Pickup & Drop</a></li>
                      <li><a class="dropdown-item" href="#" id="v-pills-helpassistance-tab" data-bs-toggle="pill" data-bs-target="#v-pills-helpassistance">24-Hour Help Assistance</a></li>
                      <li><a class="dropdown-item" href="#" id="v-pills-road-text-tab" data-bs-toggle="pill" data-bs-target="#v-pills-road-text">Road Tax & Registration</a></li>
                      <li><a class="dropdown-item" href="#" id="v-quick-guide-tab" data-bs-toggle="pill" data-bs-target="#v-pills-quick-guide">Quick Guide: Mobile App Usage</a></li>
                    </ul>
                  </div>


                  <!-- Hidden native select to maintain form integrity and screen reader support -->



                   <div class="dropdown d-inline-flex align-items-center" style="max-width: 300px; width: 100%;">
  <!-- Main tab button -->
  <button class="nav-link flex-grow-1 text-start"
    id="v-pills-insurance-tab"
    data-bs-toggle="pill"
    data-bs-target="#v-pills-insurance"
    type="button"
    role="tab"
    aria-controls="v-pills-insurance"
    aria-selected="false"
    style="width: 100%;">
    Insurance
  </button>

  <!-- Dropdown toggle -->
  <button class="btn dropdown-toggle dropdown-toggle-split"
    type="button"
    data-bs-toggle="dropdown"
    aria-expanded="false"
    aria-label="Toggle Dropdown"
    style="background: transparent; border: none; box-shadow:none; position: absolute; right: 0px;">
    <span class="visually-hidden">Toggle Dropdown</span>
  </button>

  <!-- Dropdown menu -->
  <ul class="dropdown-menu" style="width:100%">
    <li>
      <a class="dropdown-item" href="#" id="v-pills-insurance-underwriting-tab" data-bs-toggle="pill" data-bs-target="#v-pills-insurance-underwriting">Insurance Underwriting</a>
    </li>
    <li>
      <a class="dropdown-item" href="#" id="v-pills-motor-claims-tab" data-bs-toggle="pill" data-bs-target="#v-pills-motor-claims">Motor Claims</a>
    </li>
  </ul>
</div>

                  <button class="nav-link" id="v-pills-miscellaneous-tab" data-bs-toggle="pill"
                    data-bs-target="#v-pills-miscellaneous" type="button" role="tab"
                    aria-controls="v-pills-miscellaneous" aria-selected="false">Miscellaneous
                  </button>

                  <button class="nav-link" id="v-pills-general-tab" data-bs-toggle="pill"
                    data-bs-target="#v-pills-general" type="button" role="tab" aria-controls="v-pills-general"
                    aria-selected="false">CV Lease –
                    General
                  </button>

                </div>
                <div class="tab-content" id="v-pills-tabContent">
                  <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel"
                    aria-labelledby="v-pills-home-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            What is vehicle leasing?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>Vehicle leasing is the globally preferred method for
                              acquisition
                              of an automobile & provides a one-stop solution for all
                              needs in relation to the vehicle starting from the
                              choice of
                              the
                              appropriate vehicle, financing, procurement and
                              documentation, insurance renewals and management,
                              maintenance
                              and in the end, disposal of the asset.</p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            What type of leasing is available in India?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>There are generally 2 types of leasing products available
                              in
                              India.</p>

                            <p><strong>An operating lease</strong> is generally treated
                              like
                              renting. That means the lease payments are treated as
                              operating
                              expenses
                              and the asset does not show on the balance sheet.</p>

                            <p><strong>A financial lease</strong> is generally treated
                              like
                              loan. Here, asset ownership is considered by the lessee,
                              so
                              the
                              asset
                              appears on the balance sheet</p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            What are the types of operating lease?
                          </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>There are basically two types of operating lease:</p>

                            <p><strong>A dry lease,</strong> which is a product offered
                              by
                              the leasing company wherein, ex-showroom, road tax and
                              insurance for the contracted lease
                              tenure is funded by the leasing company. However, this
                              does
                              not include maintenance. Under this product, there is no
                              kilometre restriction applicable on the leased car, as
                              the
                              maintenance of the vehicle is taken care of by the
                              employee
                              himself/herself, as per the vehicle usage.</p>

                            <p><strong>A wet lease,</strong> on the other hand, means
                              that
                              the leasing company will arrange for the full funding of
                              the
                              vehicle and will also manage
                              the maintenance of the vehicle, including tyres and
                              batteries. Under this product option, an employee may
                              choose
                              the
                              kilometres required for the contracted tenure, and the
                              leasing company shall budget the maintenance on the
                              vehicle
                              accordingly.</p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            What is the difference between a rental car and a leased
                            car?
                          </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>In the case of rental cars, in general, users select a
                              car
                              that a rental car company has prepared and rents it for
                              a
                              short period. In the case of a vehicle lease (auto
                              lease),
                              the model, grade, color, and other specifics can be
                              customized according to the customer’s liking and can
                              use
                              the car for an extended period.
                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            What is Fleet management services (FMS)?
                          </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>FMS includes services such as maintenance, road tax
                              funding
                              and insurance funding. Optional services may also be
                              opted
                              such as accident depreciation waiver, Quick Replacement Car, 24/7 break down assistance
                              and total loss
                              theft
                              retention
                              which will form a part of the FMS.
                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSix">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                            What are the Benefits of Lease?
                          </button>
                        </h2>
                        <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <h4>Safety and reliability –</h4>
                            <p>
                              We have an extensive network of maintenance workshops
                              across
                              the country, allowing vehicles to be used with no worry.
                              In case of an accident or failure, we respond quickly to
                              prevent your operational efficiency from dropping.
                            </p>

                            <h4>Outsourcing your vehicle management –</h4>
                            <p>
                              Focus human resources and funds on core business by
                              outsourcing vehicle management work. By outsourcing your
                              vehicle
                              management work to us, you will be able to separate that
                              work from your company and focus human resources and
                              funds
                              on
                              your core business.
                            </p>

                            <h4>Cost cutting –</h4>
                            <p>
                              WLeveraging our economy of scale, we help you cut costs
                              for
                              vehicle purchase, maintenance, disposal, and others. We
                              offer
                              you total support in vehicle-related cost reductions
                              from
                              every angle, from proposal of optimal vehicle types to
                              fuel
                              cost management and risk management support for reducing
                              accidents.
                            </p>

                            <h4>Financial and accounting merits –</h4>
                            <p>All the vehicle-related costs you pay are the fixed lease
                              fees only, which makes budget and fund management easier
                              to
                              do. By avoiding the need to obtain large amounts of
                              capital
                              or the immobilization of funds, you will have more
                              credit
                              availability. All the lease fees can be deduced as
                              expenses
                              if it can be processed under a rental contract.
                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSeven">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                            Can any kind of vehicle be leased?
                          </button>
                        </h2>
                        <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>All kinds of vehicle that are registerable can be leased
                              under this scheme. The customer can choose any model.
                              Vehicle
                              lease (auto leases) apply to any kind of vehicle,
                              including
                              domestic and foreign passenger cars, trucks, vans, buses
                              and
                              other vehicles used for logistics, special and large
                              vehicles such as specially-equipped vehicles, forklifts,
                              refrigerated trucks, etc. Users can also specify the
                              colours, the options, and even add their logos and
                              company
                              names.
                            </p>

                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-introduction" role="tabpanel"
                    aria-labelledby="v-pills-introduction-tab">

                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            Can we convert our ownership of a car into a lease
                            agreement?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>With our “leaseback system option”, yes, it is possible.
                              We
                              recommend you get in touch with our 24×7 helpline team
                              on
                              1800-500-1212 to know about the leaseback option.</p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Are there any special requirements when changing the
                            location
                            where a leased vehicle is used?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>Please contact us beforehand because changes will have to
                              be
                              made to the lease agreement contents and maintenance
                              workshop in charge of the vehicle. Moreover, because of
                              the
                              Road Transport Vehicle Act, the user will have to secure
                              a
                              new registration address in the automobile inspection
                              certificate.</p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Can the lease period be selected?
                          </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>Yes, a customer can choose between 3 to 5 years of period
                              that is economically efficient for them.</p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            What happens when the lease period ends?
                          </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>A customer can continue to use a car after paying certain
                              amount at the end of the lease tenure or can switch to a
                              new
                              car by entering a new lease agreement. If a car is no
                              longer
                              required, then the customer can return the car to the
                              company at the end of the lease period.
                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            What are the precautions in returning vehicles when the
                            lease
                            period ends?
                          </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>First of all, Leased vehicles must be returned in good
                              condition without any damage.</p>
                            <p>SMAS India will arrange for a driver to collect the
                              vehicle
                              from the office/home premises as per user convenience.
                            </p>
                            <p>The driver will inspect the automobile for the original
                              and
                              valid registration certificate, insurance certificate,
                              maintenance notebook, jack, and spare tires, etc before
                              the
                              handover.</p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSix">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                            Can a lease agreement be terminated before it ends?
                          </button>
                        </h2>
                        <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>In principle, customers cannot prematurely terminate
                              agreements</p>
                            <p>However, if a car is a total loss because of an accident
                              or
                              on any other unavoidable grounds, then an agreement can
                              be
                              terminated by having the customer pay a premature
                              termination fee.
                            </p>
                          </div>
                        </div>
                      </div>

                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-lease" role="tabpanel" aria-labelledby="v-pills-lease-tab">

                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            How are the lease fees determined for vehicle leases (auto
                            lease)?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>Lease fees are calculated according to the vehicle type,
                              special specifications, options, insurance contents
                              (insurance
                              premiums, discounts, etc.), and maintenance contents,
                              and
                              also according to the industry of the company, the
                              purpose
                              of
                              using the vehicle, and the effect on the remaining value
                              of
                              the vehicle after the intended use. The final amount is
                              reached together with the customer after considering
                              many
                              other conditions, such as the length of the lease
                              agreement,
                              the lease agreement type (if it is a maintenance lease
                              or a
                              finance lease), etc. Therefore, it can be said that
                              there is
                              no fixed price for a lease since the lease fee is
                              calculated
                              in each instance from the conditions set by the
                              customer,
                              and the lease fee may differ even if the same model of
                              car
                              is leased for the same period.</p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Can lease fees be changed during the lease period?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>In most of the cases, lease fees are not changed once
                              fixed
                              during the initial round of discussions.</p>
                            <p>However, if an additional fee is expected because of any
                              of
                              the following reasons, we will send an invoice for the
                              difference.</p>
                            <p>If a vehicle is modified or items are added for reasons
                              required by the customer and we have authorized those
                              changes.</p>
                            <p>If there is a significant change to the costs that make
                              up
                              the lease fee due to changes in specifications,
                              maintenance,
                              need for additional parts, etc. because of changes in
                              laws.
                            </p>
                            <p>When there are changes to the initial maintenance items
                              within a maintenance agreement.</p>
                            <p>When there are changes to the initial agreement
                              conditions,
                              such as regarding automobile taxes, automobile
                              insurance,
                              compulsory auto liability insurance, etc.</p>
                            <p>When the lease agreement period is changed.</p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            How are lease fees determined when re-leasing?
                          </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>The various costs involved in a re-lease will be the
                              foundation for calculating the re-lease fee.</p>
                            <p>Specifically, the following are some of the items that
                              come
                              into consideration.</p>
                            <p>Vehicle value at the time of re-leasing (remaining value
                              on
                              the previous contract – the remaining value on the
                              re-leasing contract).</p>
                            <p>Various automobile taxes during the re-leasing period.
                              Automobile insurance fees Maintenance and management
                              expenses</p>
                            <p>Note that because maintenance and management expenses
                              generally increase with the age of a vehicle, there are
                              instances
                              when the lease fee is lower for a new vehicle.</p>
                          </div>
                        </div>
                      </div>


                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-service" role="tabpanel" aria-labelledby="v-pills-service-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <p class="accordion-header" id="headingOne" style="padding: 24px;">
                          FMS includes services such as maintenance, road tax funding and insurance funding. Optional
                          services may also be opted such as accident depreciation waiver, Quick Replacement car, 24/7
                          break down assistance and total loss theft retention which will form a part of the FMS.
                        </p>

                      </div>

                    </div>

                  </div>

                  <div class="tab-pane fade" id="v-pills-insurance" role="tabpanel"
                    aria-labelledby="v-pills-insurance-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            If we switch to a lease agreement, what happens to our
                            existing
                            insurance company and insurance agent?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>We recommend using the insurance agents that we designate
                              because they are able to rapidly cope with the creation
                              of
                              accident reducing plans and they have an organization
                              that
                              can handle accidents nationwide. However, we will be
                              flexible
                              for any individual needs.</p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Are car insurance superior discounts and non-fleet class
                            rates
                            still applicable after switching to a lease agreement?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>For fleet agreements, any superior discounts that are
                              currently applied will be applied even when switching to
                              leased
                              vehicles. Even if a lease company becomes the insured
                              party,
                              the customer that is contracted with us will have their
                              superior discount applied.</p>
                            <p>In the case of non-fleet vehicles, when switching to a
                              leased
                              vehicle, in principle, currently applied non-fleet class
                              rates will be applied if the new vehicle is used for the
                              same purpose and is the same model.</p>

                          </div>
                        </div>
                      </div>

                    </div>
                  </div>
                  
                  
                  <div class="tab-pane fade" id="v-pills-insurance-underwriting" role="tabpanel"
                    aria-labelledby="v-pills-insurance-underwriting-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            What is motor insurance?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                           Motor insurance is a policy that protects you financially against losses or damages to your insured 
                           vehicle due to accidents, theft, natural disasters, 
                           and third-party liabilities as per policy terms and conditions.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                             Is motor insurance mandatory?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                            Yes, Third-party motor insurance is legally mandatory in India as per guidelines of Motor Vehicle Act. 
                            It covers liability for injury or damage to others as per policy terms and conditions but
                            does not cover your own vehicle. Due to this reason, it is always advisable to take comprehensive insurance cover.
                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            What are the types of motor insurance policies?
                          </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                            <ul>
                              <li><b>Third-party insurance</b>: Covers property damages and bodily injuries caused to Third party by insured vehicle.</li>
                              <li><b>Comprehensive insurance</b>: Covers third-party liability, damage to your own vehicle, theft, and natural disasters.</li>
                              <li><b>Own damage insurance</b>: Covers damage to your own vehicle as per coverages opted in insurance policy.</li>
                            </ul>

                            </p>

                          </div>
                        </div>
                      </div>

                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                             What does a comprehensive policy cover?
                          </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                                It includes:
                                 </p>
                            <ul>
                              <li>Accidental damage to your vehicle</li>
                              <li>Theft or total loss</li>
                              <li>Third-party legal liabilities</li>
                              <li>Personal accident cover (if this cover is taken in insurance policy)</li>
                            </ul>

                           

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                           How is the premium calculated?

                          </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>The premium depends on factors such as:</p>
                            <ul>
                                  <li>Vehicle type, make, and model</li>
                                  <li>Age of the vehicle</li>
                                  <li>Engine capacity</li>
                                  <li>Location </li>
                                   <li>Add-ons selected </li>
                                   <li>No-Claim Bonus (NCB) .... In case of insurance renewal </li>
                            </ul>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSix">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                            What is a No Claim Bonus (NCB)?
                          </button>
                        </h2>
                        <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>NCB is a discount offered by insurance company on Own damage premium for every claim-free year as per slab prescribed by competent authority. It can go up to 50% if no claims are made for five consecutive years. In case claim is taken in any policy year, then accumulated NCB becomes Zero for next year insurance renewal.</p>
                            
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSeven">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                            Can I transfer my NCB to a new vehicle?
                          </button>
                        </h2>
                        <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Yes, NCB is tied to the policyholder, not the vehicle, and can be transferred to a new car of same policy holder as per terms & conditions of insurer.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingEight">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseEight" aria-expanded="false" aria-controls="collapseEight">
                           How can I renew my motor insurance policy?
                          </button>
                        </h2>
                        <div id="collapseEight" class="accordion-collapse collapse" aria-labelledby="headingEight"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                             You can renew it:
                             </p>
                             <ul>
                                 <li>By sending email to us at <a href="insurance.support@smasindia.com">insurance.support@smasindia.com</a> (at least 15 days before insurance renewal) with car registration number in subject line. </li>
                                <li>You can also approach concerned insurance company through its website, customer care team or mobile application as per your convenience.  </li>
                             </ul>
                            
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingNine">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseNine" aria-expanded="false" aria-controls="collapseNine">
                           What are add-ons in motor insurance?
                          </button>
                        </h2>
                        <div id="collapseNine" class="accordion-collapse collapse" aria-labelledby="headingNine"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                             Some of popular add on benefits offered by insurers (subject to policy terms and conditions) are as under: 
                            </p>
                            <ul>
                              <li>Zero depreciation cover</li>
                              <li>Roadside assistance</li>
                              <li>Engine protection and Tire protection</li>
                              <li>Consumables cover and key protection</li>
                            </ul>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTen" aria-expanded="false" aria-controls="collapseTen">
                            Can I cancel my policy mid-term?
                          </button>
                        </h2>
                        <div id="collapseTen" class="accordion-collapse collapse" aria-labelledby="headingTen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Yes, you can cancel the policy by providing a valid reason and submitting required documents like alternate insurance policy, sale proof of insured vehicle. However, refund of paid premium will be as per their guidelines of insurer.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingEleven">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseEleven" aria-expanded="false" aria-controls="collapseEleven">
                            Is online motor insurance purchase safe?
                          </button>
                        </h2>
                        <div id="collapseEleven" class="accordion-collapse collapse" aria-labelledby="headingEleven"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Yes, as long as you buy it from IRDAI authorized insurance companies, agents, brokers or licensed aggregators.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwelve">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwelve" aria-expanded="false" aria-controls="collapseTwelve">
                            Which documents are required to buy motor insurance for new car & renewal cases?
                          </button>
                        </h2>
                        <div id="collapseTwelve" class="accordion-collapse collapse" aria-labelledby="headingTwelve"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                              <div class="table-wrapper" style="overflow-x: auto; -webkit-overflow-scrolling: touch;">
                                  <table class="custom-table">
  <thead class="fw-bold">
    <tr>
      <th>For new car insurance with Individual Registration</th>
      <th>For new car insurance with company registration</th>
      <th>For insurance renewal with Individual registration</th>
      <th>For insurance renewal with company registration</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td class="py-3 px-4">Invoice of selected vehicle with engine & chassis number details.</td>
      <td class="py-3 px-4">Invoice of selected vehicle with engine & chassis number details</td>
      <td class="py-3 px-4">Vehicle registration certificate (RC Card)</td>
      <td class="py-3 px-4">Vehicle registration certificate (RC Card)</td>
    </tr>
    <tr>
      <td class="py-3 px-4">Details like registration city, add on coverages required and details of registered owner</td>
      <td class="py-3 px-4">Details like registration city, add on coverages required and details of registered owner</td>
      <td class="py-3 px-4">Current insurance policy with claim status</td>
      <td class="py-3 px-4">Current insurance policy with claim status</td>
    </tr>
    <tr>
      <td class="py-3 px-4">Copy of Pan card along with Aadhar card/ Voter ID, driving license</td>
      <td class="py-3 px-4">Copies of Pan card and GST certificate</td>
      <td class="py-3 px-4">Copy of Pan card along with Aadhar card/ Voter ID, driving license</td>
      <td class="py-3 px-4">Copies of Pan card and GST certificate</td>
    </tr>
  </tbody>
</table>
                              </div>
                      
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThirteen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThirteen" aria-expanded="false" aria-controls="collapseThirteen">
                            Is there any free look in period in an insurance policy?  
                          </button>
                        </h2>
                        <div id="collapseThirteen" class="accordion-collapse collapse" aria-labelledby="headingThirteen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              The look in / free look provision to a policy means customer has 15 days/or as given by insurance company from date of policy’s receipt to revisit purchase decision. Exercising this option, if a customer decides within free look in period that the policy purchased is not suited to his/her requirements, policy can be returned to insurance company. However, paid premium paid is refunded by insurer as per 
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFourteen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFourteen" aria-expanded="false" aria-controls="collapseFourteen">
                            What will happen if I forgot to renew insurance before due date?
                          </button>
                        </h2>
                        <div id="collapseFourteen" class="accordion-collapse collapse" aria-labelledby="headingFourteen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              In case, insurance of vehicle is not renewed before due date, you need to inform insurance company immediately and they will arrange physical inspection of your vehicle. On receipt of positive inspection report and approval from insurance underwriter, insurance company can share payment link with you to renew insurance. Any claim reported in uninsured period will not be considered by insurance company.
                            </p>
                          </div>
                        </div>
                      </div>




                    </div>
                  </div>
                               <div class="tab-pane fade" id="v-pills-motor-claims" role="tabpanel"
                    aria-labelledby="v-pills-motor-claims-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                What should I do after an accident has happened in my vehicle?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            
                            <ul>
                              <li>Inform your insurer immediately for claim registration</li>
                              <li>Take photographs of the damage sustained by your vehicle.</li>
                              <li>File a police report if necessary</li>
                               <li>Submit all required documents to insurance company to initiate inspection & repair process </li>

                            </ul>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            What is cashless claim facility?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              It allows you to get your vehicle repaired at a network garage without paying upfront for repair invoice. The insurer settles the bill directly with the garage and you need to pay differential amount as per coverages taken in policy.

                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                           How can I lodge insurance claim?
                          </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              You can connect with customer care team of concerned insurance company or visit their website to initiate claim registration process and submit desired documents. Many insurers share their claim registration process on insurance policy itself.

                            </p>

                          </div>
                        </div>
                      </div>

                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            Can I take insurance claim for accessories fitted in car?
                          </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Only those accessory items can be covered under claim which are directly affected under agreed perils and are duly insured in advance by paying applicable premium to insurer.

                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                           What if approved repair work is not done as per my expectations?

                          </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>You may connect with concerned workshop’s higher management for resolution of given issues and involve insurance company’s representative as well.</p>


                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSix">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                             What is compulsory deductible in insurance policy?

                          </button>
                        </h2>
                        <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>It is amount which insured/car user has to pay per insurance claim and it is deducted from total assessed payable claim amount before determining insurance company’s liability. </p>
                        <table class="custom-table">
  <thead>
    <tr>
      <th>Engine Cubic<br>Capacity (cc)</th>
      <th>Compulsory<br>Deductible per claim</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>Less than 1500</td>
      <td>1000</td>
    </tr>
    <tr>
      <td>More than 1500</td>
      <td>2000</td>
    </tr>
  </tbody>
</table>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSeven">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                            What is not covered under a motor insurance policy?

                          </button>
                        </h2>
                        <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                           <li>Driving a vehicle without a valid license</li>
                           <li>Driving under the influence of alcohol or drugs</li>
                           <li>Mechanical or electrical breakdown</li>
                           <li>Regular wear and tear</li>
                           <li>Using the vehicle for illegal activities</li>
                           <li>Not following Laws of Land</li>


                          </div>
                        </div>
                      </div>
                    </div>
                  </div>




                  <!--dropdown tabs-->
                  <div class="tab-pane fade" id="v-pills-maintenance" role="tabpanel"
                    aria-labelledby="v-pills-maintenance-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            What is included in maintenance/service?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                            <ul>
                              <li>Service schedule as per manufacturer guidelines</li>
                              <li>Complete repair and maintenance</li>
                              <li>Cost of repairs or replacement of parts due to normal wear and tear</li>
                              <li> Use of genuine fluids as specified by the manufacturer</li>
                              <li> Use of genuine fluids as specified by the manufacturer</li>
                              <li> Immediate support for dashboard warning lights</li>
                              <li> All wear and tear items as per recommended mileage or time</li>
                            </ul>

                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            How do I receive service reminders for my car?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                            <ul>
                              <li>Undetected faults or rejection of warranty caused due to irregularity in general
                                inspection by the user/lessee.</li>
                              <li>Non-adherence to service schedule causing premature part failure</li>
                              <li>Accessories or parts fitted externally</li>
                              <li>Broken, missing, or stolen parts</li>
                              <li>Use of non-branded or unauthorized fluids</li>
                              <li>Driving the vehicle despite warning signs</li>
                              <li>Clutch overriding, engine failure due to ignoring warnings, gearbox damage due to
                                improper use</li>
                              <li>Washing and cleaning only</li>
                              <li>PUC, external beautification, tyre punctures, fuel, AdBlue (if service not opted)</li>
                            </ul>

                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            What are the exclusions under maintenance service?
                          </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                            <ul>
                              <li>A system-generated email will be sent to your registered email ID with service
                                reminder details and booking options</li>
                              <li>You can also update your vehicle’s current KM reading on the mobile app to receive
                                timely reminders</li>

                            </ul>

                            </p>

                          </div>
                        </div>
                      </div>

                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            What if I don’t receive a service reminder?
                          </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                            <ul>
                              <li>Please update and verify your contact details (email ID and mobile number) in the SMAS
                                records through your account manager</li>
                              <li>Alternatively, you can contact the SMAS helpline at 1860-500-1212, email
                                <a href="mailto:service@smasindia.com">service@smasindia.com</a> , or update the current KM reading on the mobile app
                              </li>

                            </ul>

                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            How can I book a service?

                          </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>It is easy to book your service appointment using any of the following options:</p>
                            <ul>
                              <li>
                                Mobile App:
                                <ol class="mt-2 mb-2">
                                  <li>Download the SMAS India App from the Play Store or iOS Store.</li>
                                  <li>Sign up using your email ID, contact number, or username.</li>
                                  <li>Log in using your registered mobile number/email and OTP.</li>
                                  <li>Book service, repair, maintenance, or accident assistance for your preferred date.
                                  </li>
                                </ol>
                                <p>
                                  <a href="{{ asset('front') }}/pdf/User_Manual_Mobile_Application.pdf" target="_blank">
                                    Click here to view the Quick Guide for Mobile App Usage.
                                  </a>
                                </p>
                              </li>
                              <li>Call: 1860-500-1212</li>
                              <li>
                                Email:
                                <a href="mailto:service@smasindia.com">service@smasindia.com</a>
                              </li>
                            </ul>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSix">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                            How do I get reimbursement for a service I paid for at the workshop?
                          </button>
                        </h2>
                        <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>If the repair was pre-approved, please email the following documents to <a
                                href="mailto:service@smasindia.com">service@smasindia.com</a>:</p>
                            <ol>
                              <li>Tax invoice copy</li>
                              <li>Cancelled cheque / account details / passbook copy</li>
                              <li>ID proof</li>
                            </ol>
                            <p>Please note that the reimbursement is generally processed within <strong>7 working
                                days</strong>.</p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSeven">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                            What is consequential loss?
                          </button>
                        </h2>
                        <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Consequential loss refers to damage caused by ignoring warning signs, unusual noises, or
                              irregular driving behaviour.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingEight">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseEight" aria-expanded="false" aria-controls="collapseEight">
                            What is hydrostatic locking?
                          </button>
                        </h2>
                        <div id="collapseEight" class="accordion-collapse collapse" aria-labelledby="headingEight"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Hydrostatic locking refers to engine damage caused by water entering the combustion
                              chamber, which leads to
                              severe internal engine failure.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingNine">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseNine" aria-expanded="false" aria-controls="collapseNine">
                            What should I do if my vehicle meets with an accident or breaks down?
                          </button>
                        </h2>
                        <div id="collapseNine" class="accordion-collapse collapse" aria-labelledby="headingNine"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              We have a 24x7 helpline assistance service covering over 2000 cities. You can:
                            </p>
                            <ul>
                              <li>Call <strong>1800-266-6211</strong></li>
                              <li>Press the <strong>SOS</strong> button on the top right corner of the mobile app home
                                page</li>
                            </ul>
                            <p>
                              Our team will ask for your location and vehicle details to send assistance.
                            </p>
                            <p>
                              <strong>Note:</strong> Towing is free up to 100 km (if the service is opted). Beyond 100
                              km, extra charges apply.
                            </p>
                            <p>
                              If your vehicle doesn’t require towing or you haven’t opted for the helpline service, you
                              can reach us via:
                            </p>
                            <ol>
                              <li>Mobile app</li>
                              <li>Call: 1860-500-1212</li>
                              <li>Email: <a href="mailto:service@smasindia.com">service@smasindia.com</a></li>
                            </ol>
                            <p>
                              <strong>Please Note:</strong> If vehicle recovery requires lifting with a Hydra Crane,
                              charges for the same will not be covered.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTen" aria-expanded="false" aria-controls="collapseTen">
                            How do I know the service schedule for my vehicle?
                          </button>
                        </h2>
                        <div id="collapseTen" class="accordion-collapse collapse" aria-labelledby="headingTen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Please refer to the user/owner manual provided by the manufacturer at the time of vehicle
                              delivery. For assistance, contact our service line at 1860-500-1212.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingEleven">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseEleven" aria-expanded="false" aria-controls="collapseEleven">
                            Is the last service before the contract end date covered?
                          </button>
                        </h2>
                        <div id="collapseEleven" class="accordion-collapse collapse" aria-labelledby="headingEleven"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Scheduled services due around the contract’s end date are <strong>not covered</strong>.
                              However, emergency and breakdown services are included.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwelve">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwelve" aria-expanded="false" aria-controls="collapseTwelve">
                            Will pick-up & drop or a replacement car be provided when the vehicle is in the workshop for
                            maintenance?
                          </button>
                        </h2>
                        <div id="collapseTwelve" class="accordion-collapse collapse" aria-labelledby="headingTwelve"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              It will depend on the services opted by you or your company under the lease agreement.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThirteen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThirteen" aria-expanded="false" aria-controls="collapseThirteen">
                            How do I handle unapproved or non-contracted repairs?
                          </button>
                        </h2>
                        <div id="collapseThirteen" class="accordion-collapse collapse" aria-labelledby="headingThirteen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Kindly check the inclusions/exclusions listed above and refer to the user manual shared in
                              the welcome email at the start of the contract.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFourteen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFourteen" aria-expanded="false" aria-controls="collapseFourteen">
                            How can I check the work done on my vehicle and get updates on delivery?
                          </button>
                        </h2>
                        <div id="collapseFourteen" class="accordion-collapse collapse" aria-labelledby="headingFourteen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Please log in to the mobile app to view the job details including repair/replacement
                              status.<br>
                              Delivery date and time will be shared via email or app notification.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFifteen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFifteen" aria-expanded="false" aria-controls="collapseFifteen">
                            Who should be contacted about maintenance and questions about accidents?
                          </button>
                        </h2>
                        <div id="collapseFifteen" class="accordion-collapse collapse" aria-labelledby="headingFifteen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              We have a dedicated helpline number for this matter. Users can call us on
                              1860-500-1212 for service and maintenance-related queries.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSixteen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSixteen" aria-expanded="false" aria-controls="collapseSixteen">
                            Where should we have leased vehicles inspected?
                          </button>
                        </h2>
                        <div id="collapseSixteen" class="accordion-collapse collapse" aria-labelledby="headingSixteen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Vehicles where the maintenance & service has been opted by the user can simply deliver
                              their vehicle to the service stations for inspections covered in maintenance agreements.
                              Those who have not, will have to arrange for their own inspections.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSeventeen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSeventeen" aria-expanded="false" aria-controls="collapseSeventeen">
                            If we enter a maintenance lease agreement, which maintenance workshop can be used?
                          </button>
                        </h2>
                        <div id="collapseSeventeen" class="accordion-collapse collapse"
                          aria-labelledby="headingSeventeen" data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              We will introduce customers to recommended maintenance workshops that meet our standards
                              after considering the location where the car is used, the type of vehicle, etc.
                            </p>
                          </div>
                        </div>
                      </div>




                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-tyres" role="tabpanel"
                    aria-labelledby="v-pills-tyres-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            What are the exclusions under tyre and battery services?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              The Tyres and Battery services do not include:</p>
                            <ul>
                              <li>Consequential loss</li>
                              <li>Premature failure</li>
                              <li>External damage</li>

                            </ul>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            How frequently are the tyres replaced?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Replacement of tyres depends on the condition (not mileage) and is done only at authorized dealers.

                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            How often is the battery replaced?
                          </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Battery replacement also depends on actual condition and is handled through authorized dealers only.

                            </p>

                          </div>
                        </div>
                      </div>

                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            What brand of tyre will be used?
                          </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Tyre brands are specified by the leasing partner. If the lessee/user requests a specific brand, they must pay the price difference directly to the vendor.

                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            Will the tyre size be changed?

                          </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>No. Tyre size cannot be changed, as it affects vehicle warranty. Any accident or claim due to size changes will be at the user’s/lessee’s cost.</p>


                          </div>
                        </div>
                      </div>

                    </div>
                  </div>
                  <div class="tab-pane fade" id="v-pills-adw" role="tabpanel"
                    aria-labelledby="v-pills-adw-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            What happens if the insurance company declines the claim?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              All documents and accident details will be reviewed. If the claim is denied, we’ll notify you and proceed with repairs upon your approval.</p>


                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            What if my vehicle is involved in an accident, is stolen, or declared a total loss?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Call 1860-500-1212 or email <a href="mailto:service@smasindia.com">service@smasindia.com</a>
                              Our team will guide you with the next steps.

                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            What if there’s a third-party claim, FIR, or legal case?
                          </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              SMAS Team should be immediately informed about the accident and briefed on the situation. The insurance company will be notified, and the claim will be processed once legal clearance is received.

                            </p>

                          </div>
                        </div>
                      </div>

                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            Who is responsible for legal cases?
                          </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              The registered owner of the vehicle will be responsible. The contract will continue until all legal matters are resolved and documentation is complete.

                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            When should I report an accident to SMAS?

                          </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>As soon as possible. Call 1860-500-1212 or email <a href="mailto:service@smasindia.com">service@smasindia.com</a> immediately.</p>


                          </div>
                        </div>
                      </div>

                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-replacement" role="tabpanel"
                    aria-labelledby="v-pills-replacement-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            What is the facility under Quick Replacement Car?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              A self-driven commercial number plate vehicle with pickup and drop included (advance intimation required).
                              Applicable for breakdown/accident cases, car provided the next day.

                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            In which cities is the replacement car service available?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Replacement car service is currently available in the following cities:
                              New Delhi, Gurugram, Noida, Ghaziabad, Greater Noida, Mumbai, Navi Mumbai, Pune, Manesar, Kolkata, Chennai, Hyderabad, Bangalore & Ahmedabad.

                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Will the replacement car have a private or commercial registration?
                          </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Only self-driven commercial number plate vehicles are provided.

                            </p>

                          </div>
                        </div>
                      </div>

                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            Who bears the cost of fuel, tolls, taxes, and parking?
                          </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              The user/lessee must bear all costs other than the daily rental fee.

                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            Will I receive a chauffeur-driven or self-driven car?

                          </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>Only self-driven cars are provided.</p>


                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSix">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                            What type of replacement car will I receive?
                          </button>
                        </h2>
                        <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>You’ll get a similar category vehicle or one tier lower, up to a maximum of an Innova Crysta, depending on your leased vehicle.
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSeven">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                            How can I request a replacement car if my vehicle goes for repair/accident service?
                          </button>
                        </h2>
                        <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              You can request a replacement car via:
                            </p>
                            <ul>
                              <li>Mobile App (raise request along with service/accident booking)</li>
                              <li>Email: <a href="mailto:service@smasindia.com">service@smasindia.com</a></li>
                              <li>Call: 1860-500-1212</li>
                            </ul>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingEight">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseEight" aria-expanded="false" aria-controls="collapseEight">
                            What happens if the replacement car is involved in an accident?
                          </button>
                        </h2>
                        <div id="collapseEight" class="accordion-collapse collapse" aria-labelledby="headingEight"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              If the ADW (Accident Depreciation Waiver) service is included in your lease contract, the cost will be covered.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingNine">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseNine" aria-expanded="false" aria-controls="collapseNine">
                            Is this service limited to certain cities?
                          </button>
                        </h2>
                        <div id="collapseNine" class="accordion-collapse collapse" aria-labelledby="headingNine"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Yes. Please check the service coverage cities before opting for this facility.
                            </p>


                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTen" aria-expanded="false" aria-controls="collapseTen">
                            Can I use the replacement car after my leased vehicle is repaired?
                          </button>
                        </h2>
                        <div id="collapseTen" class="accordion-collapse collapse" aria-labelledby="headingTen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              No. Once your leased vehicle is back, the replacement car must be returned immediately. Additional charges will apply for delays.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingEleven">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseEleven" aria-expanded="false" aria-controls="collapseEleven">
                            Can I get a replacement car for non-contracted services?
                          </button>
                        </h2>
                        <div id="collapseEleven" class="accordion-collapse collapse" aria-labelledby="headingEleven"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              No. This is available only for contracted services.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwelve">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwelve" aria-expanded="false" aria-controls="collapseTwelve">
                            What if the replacement car is involved in traffic violations or illegal activities?
                          </button>
                        </h2>
                        <div id="collapseTwelve" class="accordion-collapse collapse" aria-labelledby="headingTwelve"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              In such cases, all penalties, legal fees, and additional charges will be passed on to the lessee/user.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThirteen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThirteen" aria-expanded="false" aria-controls="collapseThirteen">
                            Will I get preference in receiving a replacement car if my vehicle is immobilized?
                          </button>
                        </h2>
                        <div id="collapseThirteen" class="accordion-collapse collapse" aria-labelledby="headingThirteen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Replacement is based on availability and urgency. Priority is given depending on location and vendor operating hours.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFourteen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFourteen" aria-expanded="false" aria-controls="collapseFourteen">
                            Does the maintenance service include providing a replacement vehicles at the time of accident or repairs etc?
                          </button>
                        </h2>
                        <div id="collapseFourteen" class="accordion-collapse collapse" aria-labelledby="headingFourteen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              The conditions for providing a replacement vehicle depend on the contents of the agreement.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFifteen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFifteen" aria-expanded="false" aria-controls="collapseFifteen">
                            Who should be contacted about maintenance and questions about accidents?
                          </button>
                        </h2>
                        <div id="collapseFifteen" class="accordion-collapse collapse" aria-labelledby="headingFifteen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              We have a dedicated helpline number for this matter. Users can call us on
                              1860-500-1212 for service and maintenance-related queries.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSixteen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSixteen" aria-expanded="false" aria-controls="collapseSixteen">
                            Where should we have leased vehicles inspected?
                          </button>
                        </h2>
                        <div id="collapseSixteen" class="accordion-collapse collapse" aria-labelledby="headingSixteen"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Vehicles where the maintenance & service has been opted by the user can simply deliver
                              their vehicle to the service stations for inspections covered in maintenance agreements.
                              Those who have not, will have to arrange for their own inspections.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSeventeen">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSeventeen" aria-expanded="false" aria-controls="collapseSeventeen">
                            If we enter a maintenance lease agreement, which maintenance workshop can be used?
                          </button>
                        </h2>
                        <div id="collapseSeventeen" class="accordion-collapse collapse"
                          aria-labelledby="headingSeventeen" data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              We will introduce customers to recommended maintenance workshops that meet our standards
                              after considering the location where the car is used, the type of vehicle, etc.
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-pickup" role="tabpanel"
                    aria-labelledby="v-pills-pickup-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            What if the vehicle gets damaged during pickup/drop?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              The damage will be covered under insurance, as per your leased vehicle service terms.
                            </p>


                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Are pickup/drop drivers employed by SMAS?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              No. We work with trusted third-party vendors to manage pickup and drop services.

                            </p>

                          </div>
                        </div>
                      </div>

                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-helpassistance" role="tabpanel"
                    aria-labelledby="v-pills-helpassistance-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            What should I do if the vehicle breaks down, meets with an accident, or needs towing?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">

                            <ul>
                              <li>Call 24x7 helpline 1800-266-6211. We have tie-up with helpline assistance team covering 2000+ cities</li>
                              <li>Or press the SOS button on the mobile app</li>
                            </ul>
                            <p>
                              Our team will collect your vehicle and location details. Assistance is free (if opted) for up to 100 km. Additional distance will be chargeable.
                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            What if towing is not required?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Reach out through:

                            </p>
                            <ul>
                              <li>Mobile app</li>
                              <li>Call: 1860-500-1212</li>
                              <li>Email: <a href="mailto:service@smasindia.com">service@smasindia.com</a></li>
                            </ul>
                            <p>
                              <strong>Please Note:</strong> If vehicle recovery requires lifting with a Hydra Crane,
                              charges for the same will not be covered.
                            </p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            How long will it take for recovery or towing assistance?
                          </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Typically, 60–75 minutes. Timings may vary based on location, traffic, and road conditions.

                            </p>

                          </div>
                        </div>
                      </div>

                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            What if the vehicle is damaged during towing or vendor assistance?
                          </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>
                              Such damages are covered under insurance and processed based on the lease plan opted.

                            </p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            What should the user/lessee do to enable towing?

                          </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>Ensure the vehicle is in an open area with space for the tow truck to access and move the vehicle easily.</p>


                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSix">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                            What should we do when there is a vehicle break down or an accident at a remote location, on a Saturday, holiday, or at night?
                          </button>
                        </h2>
                        <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <h4>Safety and reliability –</h4>
                            <p>
                              Customers who have signed a maintenance lease agreement should call the toll-free service number 1800-266-6211 when there is an emergency.
                              We will direct them to an maintenance workshop, dealer garage, road service, or another service that is nearby. For emergencies on highways, please use the dedicated emergency telephones and follow the directions of the operator.
                            </p>

                          </div>
                        </div>
                      </div>

                    </div>
                  </div>
                  
                     <div class="tab-pane fade" id="v-pills-quick-guide" role="tabpanel" aria-labelledby="v-quick-guide-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item" style="border: 1px solid rgba(0, 0, 0, .125);">
                        <p class="accordion-header" id="headingOne" style="padding: 24px;">
                          <a href="{{ asset('front') }}/pdf/User_Manual_Mobile_Application.pdf" target="_blank">
                                    Click here to view the Quick Guide for Mobile App Usage.
                                  </a>
                        </p>

                      </div>

                    </div>

                  </div>

                  <div class="tab-pane fade" id="v-pills-miscellaneous" role="tabpanel"
                    aria-labelledby="v-pills-miscellaneous-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            Can you take the existing vehicles that we own off our
                            hands?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>We will buy any surplus vehicles that a customer does not
                              need. We will resell them after removing any company
                              names,
                              logos, etc. After completing such transactions, we will
                              provide a copy of the automobile inspection certificate
                              after
                              the ownership has been transferred.</p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Can forklifts also be leased?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>We also lease forklifts. Forklifts require inspection
                              specified by the Industrial Safety and Health Act and
                              operating
                              licenses so that it is necessary to create a management
                              system that is just as strict as that for cars. We were
                              the
                              first company in our industry to make a support system
                              that
                              is similar to that for vehicle leases (auto leases).</p>

                          </div>
                        </div>
                      </div>

                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-general" role="tabpanel" aria-labelledby="v-pills-general-tab">
                    <div class="accordion" id="accordionExample">
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                          <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            Why opt for commercial vehicle Lease?
                          </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>Get full GST benefit as earlier, legal and tax
                              implications
                              and different tax rate for each state lead to a lot of
                              complexity coupled with marketing and recovery
                              bottlenecks
                              and other several impediments. Now leasing a commercial
                              vehicle becomes cheaper when GST benefit is fully passed
                              on
                              to a customer.</p>
                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Why SMAS commercial vehicle Lease?
                          </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>With Flexible Funding options, Long-term approval
                              validity,
                              Faster Credit Appraisals, SMAS India is the only focused
                              player in the market for commercial vehicle leasing.</p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            What is the Loan-To-Value (LTV) offered by SMAS India?
                          </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>This is fully dependent on deal to deal basis but mostly
                              ranges between 85% to 100%.</p>

                          </div>
                        </div>
                      </div>
                      <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            What are the type of assets that can be funded by SMAS
                            India?
                          </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                          data-bs-parent="#accordionExample">
                          <div class="accordion-body">
                            <p>SMAS India commercial leasing includes all ICV, SCV, MCV,
                              HCV, Fork Lifts, Cranes, etc. clubbed with registrable
                              CE
                              assets.</p>

                          </div>
                        </div>
                      </div>

                    </div>
                  </div>

                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

    </section>

  </div>

  <script>
    // grab every single pill toggle (buttons, divs, etc)
    document.querySelectorAll('[data-bs-toggle="pill"]').forEach(el => {
      el.addEventListener('click', e => {
        // 1) clear active on all nav-links
        document.querySelectorAll('.nav-link').forEach(btn => {
          btn.classList.remove('active');
        });
        // 2) clear active on any dropdown-item too (if you style them active)
        document.querySelectorAll('.dropdown-item').forEach(item => {
          item.classList.remove('active');
        });

        // 3) mark *this* trigger as active
        e.currentTarget.classList.add('active');

        // 4) tell Bootstrap to show the right pane
        //    only necessary if your trigger isn't a real <a> or <button>
        var target = e.currentTarget.getAttribute('data-bs-target');
        if (target) {
          var pane = document.querySelector(target);
          // hide any other .tab-pane.active
          document.querySelectorAll('.tab-pane.active').forEach(p => p.classList.remove('active'));
          // show this one
          pane.classList.add('active');
        }
      });
    });
  </script>
  <script>
    const customSelect = document.getElementById('customSelect');
    const toggleButton = document.getElementById('v-pills-service-tab');
    const dropdownList = document.getElementById('customSelectList');

    // Initially hide the dropdown
    dropdownList.style.display = 'none';

    // Toggle dropdown on button click
    toggleButton.addEventListener('click', (e) => {
      e.stopPropagation(); // Prevent click from bubbling up
      const isVisible = dropdownList.style.display === 'block';
      dropdownList.style.display = isVisible ? 'none' : 'block';
    });

    // Close dropdown on outside click
    document.addEventListener('click', (e) => {
      if (!customSelect.contains(e.target)) {
        dropdownList.style.display = 'block';
      }
    });

    // Optional: Close dropdown when an item is clicked
    dropdownList.querySelectorAll('.dropdown-item').forEach(item => {
      item.addEventListener('click', () => {
        dropdownList.style.display = 'none';
        // Optional: update button text if needed

      });
    });
  </script>





  @endsection