<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_id');
            $table->integer('user_id');
            $table->float('sub_total');
            $table->float('total_discount')->nullable();
            $table->float('shipping_charge')->nullable();
            $table->string('coupan_name')->nullable();
            $table->string('coupan_type')->nullable();
            $table->string('coupan_discount')->nullable();
            $table->integer('grand_total')->nullable();
            $table->string('payment_type')->nullable();
            $table->integer('payment_status')->nullable()->comment('0 for pending, 1 for completed,2 for cancelled');
            $table->longText('payment_gateway_response')->nullable();
            $table->longText('shiprocket_response')->nullable();
            $table->text('remarks')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
