<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\View;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    // public function boot()
    // {
    //     //
        
    // if (env('APP_ENV') === 'local') {
    //     URL::forceScheme('https');
    // }
    //     Paginator::useBootstrap();
    // }
    
    // public function boot()
    // {
    //     if (env('APP_ENV') === 'local') {
    //         URL::forceScheme('https');
    //     }
    
    //     Paginator::useBootstrap();
    

    //   $nonce = bin2hex(random_bytes(16));
    //     View::share('csp_nonce', $nonce);
    // }
    
    
//     public function boot()
// {
//     // ✅ Force HTTPS in local environment
//     if (env('APP_ENV') === 'local') {
//         URL::forceScheme('https');
//     }

//     // ✅ Use Bootstrap pagination views
//     Paginator::useBootstrap();

//     // ✅ Share CSP Nonce for inline scripts
//     $nonce = bin2hex(random_bytes(16));
//     View::share('csp_nonce', $nonce);

//     // ✅ Protect against Host Header Injection
//     $allowedHosts = ['smasindia.com', 'www.smasindia.com'];
//     $currentHost = request()->getHost();

//     if (!in_array($currentHost, $allowedHosts)) {
//         abort(403, 'Forbidden: Invalid Host');
//     }
// }


    public function boot()
    {
        // ✅ Force HTTPS in local environment
        if (env('APP_ENV') === 'local') {
            URL::forceScheme('https');
        }
    
        // ✅ Use Bootstrap pagination views
        Paginator::useBootstrap();
    
        // ✅ Share CSP Nonce for inline scripts
        $nonce = bin2hex(random_bytes(16));
        View::share('csp_nonce', $nonce);
    
        // ✅ Protect against Host Header Injection
        $allowedHosts = [
            'smasindia.com',
            'www.smasindia.com',
            'smasindia.99isolutions.com',  // ✅ Add this to allow your staging/subdomain
        ];
    
        $currentHost = request()->getHost();
    
        if (!in_array($currentHost, $allowedHosts)) {
            abort(403, 'Forbidden: Invalid Host');
        }
    }

}
