<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SanitizeRequestHeaders
{
    public function handle(Request $request, Closure $next)
    {
        // Sanitize common headers
        $headersToSanitize = ['user-agent', 'referer', 'x-forwarded-for', 'host'];

        foreach ($headersToSanitize as $header) {
            if ($request->hasHeader($header)) {
                $cleanedValue = $this->sanitize($request->header($header));
                $request->headers->set($header, $cleanedValue);
            }
        }

        return $next($request);
    }

    protected function sanitize($value)
    {
        // Strip newline, carriage return, and other dangerous characters
        return preg_replace('/[\r\n]+/', '', htmlspecialchars($value, ENT_QUOTES, 'UTF-8'));
    }
}
