<?php

namespace App\Http\Middleware;

use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken as Middleware;
use Illuminate\Support\Facades\Cookie;

class CustomVerifyCsrfToken extends Middleware
{
    protected function addCookieToResponse($request, $response)
    {
        // Call the parent method to set the CSRF cookie
        $response = parent::addCookieToResponse($request, $response);

        // Set HttpOnly = true on XSRF-TOKEN manually
        $response->headers->setCookie(
            Cookie::make(
                'XSRF-TOKEN',
                $request->session()->token(),
                120, // minutes
                '/',
                null,
                config('session.secure'), // true if using HTTPS
                true, // HttpOnly = true
                false, // raw = false
                'Strict' // SameSite policy
            )
        );

        return $response;
    }
}
