@extends('front.layouts.masterhome')

@section('meta_title', 'Top Automobile Leasing Company in India | SMAS India')
@section('meta_description', 'SMAS India offers reliable automobile leasing solutions in India. Discover flexible auto leasing options for businesses and individuals. Visit us today!')

@section('section')
<div class="no-bottom no-top" id="content">
    <div id="top"></div>
    <section id="section-hero" aria-label="section" class="jarallax full-height vertical-center">
        <!-- <img src="{{ secure_asset('front') }}/images/background/1.jpg" class="jarallax-img" alt=""> -->
        <div class="slidervideo">
            <!--<video autoplay loop muted playsinline poster=""-->
            <!--    src="{{ secure_asset('front') }}/banner_2.mp4">-->
            <!--    <source src="{{ secure_asset('front') }}/banner_2.mp4" type="video/mp4">-->
            <!--    </source>-->
            <!--    <source src="{{ secure_asset('front') }}/july-linked-comp-01.webm" type="video/webm">-->
            <!--    </source>-->
            <!--    <source src="{{ secure_asset('front') }}/july-linked-comp-01.mov" type="video/mov">-->
            <!--    </source>-->
            <!--</video>-->
            
            <video
          id="lazy-video"
          data-src="{{ secure_asset('front/banner_2.mp4') }}"
          muted
          autoplay
          loop
          playsinline
          preload="none"
          poster="{{ secure_asset('front/images/banner-poster.jpg') }}"
          width="100%"
          height="auto"
        >
        </video>
        </div>
<script nonce="{{ $csp_nonce }}">
    document.addEventListener("DOMContentLoaded", function () {
        var video = document.getElementById('lazy-video');
        var src = video.getAttribute('data-src');
        if (src) {
            video.setAttribute('src', src);
        }
    });
</script>
        <div class="container-fluid position-relative z1000 slidertxt">
            <div class="row align-items-center">
                <div class="col-lg-7 text-light">
                    <!-- <h4><span class="">Fast and Easy Way to Rent a Car</span></h4>
                    <div class="spacer-10"></div> -->
                    <h1 class="mb-2">One-Stop Hub for<br /> Vehicle Leasing, Vehicle Management and more.
                    </h1>
                    <div class="spacer-10"></div>
                    <p class="lead para">Specially designed for Corporates, Employees & Commercial Fleet
                        owners.
                    </p>
                </div>

                <div class="col-lg-5">
                    <div class="spacer-single sm-hide"></div>

                </div>
            </div>
        </div>

        <img src="{{ secure_asset('front') }}/images/banner-bot.webp" class="banner-bot" alt="" loading="lazy" fetchpriority="low">
    </section>



    <div class="afterbnrsec">
        <div class="container-fluid" style="background-size: auto">
            <div class="row align-items-center pt-md-5 pt-1 pb-5">
                <div class="col-lg-6">
                    <p class="main-text">"We are a leading vehicle leasing company in India,
                        committed to
                        our customers and
                        focused
                        on delivering innovative
                        solutions. Our passionate team is dedicated to creating exceptional value by
                        prioritizing customer satisfaction and
                        ensuring a positive experience for all we serve."</p>

                </div>
                <div class="col-lg-6">
                    <div class="main-img1">
                        <!--<img src="{{ secure_asset('front/images/main.webp') }}" alt="vehicle leasing company" class="img-fluid" loading="lazy" fetchpriority="high" >-->
                        <img 
  src="{{ secure_asset('front/images/main.avif') }}" 
  alt="vehicle leasing company" 
  class="img-fluid" 
  width="600" 
  height="400" 
  fetchpriority="high"
  loading="lazy"
>
                    </div>
                </div>
            </div>

            <h2 class="text-center pt-5 pb-4">Our Products and Services</h2>
            <div class="row offset-lg-2 prSer">
                <div class="col-lg-9 col-12">
                    <div class="servicebox_outer fea-1">
                        <div class="servicebox animated">
                            <div class="project-img">
                                <img src="{{ secure_asset('front') }}/images/global/home1-1.avif" alt="car leasing company
" loading="lazy" fetchpriority="low">
                            </div>
                            <div class="project-content">
                                <h3 class="project-title"><a href="{{ route('home.services') }}#vehicle-leasing"
                                        tabindex="0">Vehicle Leasing</a>
                                </h3>
                                <p>Explore our vehicle leasing options, designed for businesses and corporates
                                    seeking flexibility and hassle-free
                                    ownership.</p>
                                <a href="{{ route('home.services') }}#vehicle-leasing" class="btn-main">Know More</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row row-cols-1 row-cols-md-2 g-4 prSer">
                <div class="col">
                    <div class="servicebox_outer fea-1">
                        <div class="servicebox animated ps2">
                            <div class="project-img">
                                <img src="{{ secure_asset('front') }}/images/global/home2.avif" alt="Fleet Management Services" loading="lazy"  fetchpriority="low">
                            </div>
                            <div class="project-content">
                                <h3 class="project-title"><a href="{{ route('home.services') }}#fleet-management"
                                        tabindex="0">Fleet Management Services</a>
                                </h3>
                                <p>Discover our all-inclusive fleet management services, designed to streamline
                                    the administration of your leased vehicles
                                    throughout their entire lifecycle. From procurement and maintenance to
                                    insurance and asset disposal, we handle every
                                    detail for you. Enjoy a hassle-free experience while effectively managing
                                    costs.</p>
                                <a href="{{ route('home.services') }}#fleet-management" class="btn-main">Know More</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="servicebox_outer fea-1">
                        <div class="servicebox animated ps2">
                            <div class="project-img">
                                <img src="{{ secure_asset('front') }}/images/global/home3-1.avif" alt="Value Added Services" loading="lazy" fetchpriority="low">
                            </div>
                            <div class="project-content">
                                <h3 class="project-title"><a href="{{ route('home.services') }}#value-added"
                                        tabindex="0">Value
                                        Added Services</a>
                                </h3>
                                <p>Our value-added services are designed to enhance your overall experience and
                                    deliver benefits beyond our core offerings.
                                    With convenient tools and features that simplify your interactions with us,
                                    we ensure you have seamless access to
                                    support and resources, making every step of your journey more efficient and
                                    enjoyable.</p>
                                <a href="{{ route('home.services') }}#value-added" class="btn-main">Know More</a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>


    </div>

    <section class="text-light jarallax whychoose sectionpadtop pb-0">
        <div class="blackoverlay pb-5">
            <div class="sectionbeforeafter"></div>
            <img src="{{ secure_asset('front') }}/images/carbg_2.avif" alt="car on lease in india" class="jarallax-img" alt="" loading="lazy" fetchpriority="low">

            <div class="container">
                <div class="row g-5 pb-5 mt-0">
                    <div class="col-lg-12">
                        <h2 class="text-center lease-head">How to <span class="id-color">Lease</span> with
                            Us.
                        </h2>
                    </div>

                    <div class="col-lg-12 col-12 aks1">
                        <div class="row text-center justify-content-between">
                            <div class="col-2">
                                <div class="processimg">
                                    <span> <img src="{{ secure_asset('front') }}/images/flow-chart.avif"
                                            alt="Reach out to us" loading="lazy" fetchpriority="low"> </span>
                                </div>
                                <h2>Reach out to us</h2>
                                <ul class="whychooselist">
                                    <li><a href="#enquiry">Enquire Now</a></li>
                                    <li><i class="fa fa-phone fa-lg"></i> Call Us: <a href="tel:01148288300"
                                           target="_blank" rel="noopener noreferrer">011-4828-8300</a></li>
                                    <li><i class="fa fa-envelope-o fa-lg"></i> Mail Us: <a
                                            href="mailto:reach_us@smasindia.com"
                                            target="_blank" rel="noopener noreferrer">reach_us@smasindia.com</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-2">
                                <div class="processimg">
                                    <span> <img src="{{ secure_asset('front') }}/images/briefing.avif"
                                            alt="SMAS India Representative connects with you." loading="lazy" fetchpriority="low"> </span>
                                </div>
                                <h2>SMAS India Representative connects with you.</h2>
                            </div>
                            <div class="col-2">
                                <div class="processimg">
                                    <span> <img src="{{ secure_asset('front') }}/images/coding.avif" alt="Select your Preferences" fetchpriority="low">
                                    </span>
                                </div>
                                <h2>Select your Preferences</h2>
                                <p class="">Select your Leasing Type, Vehicle Model, Tenure,
                                    Mileage & Value Added
                                    Services.</p>
                            </div>
                            <div class="col-2">
                                <div class="processimg">
                                    <span> <img src="{{ secure_asset('front') }}/images/checklist.avif"
                                            alt="Get your quote with attractive rentals" loading="lazy" fetchpriority="low"> </span>
                                </div>
                                <h2>Get your quote with attractive rentals</h2>
                            </div>
                            <div class="col-2">
                                <div class="processimg">
                                    <span> <img src="{{ secure_asset('front') }}/images/howlastpoint.avif"
                                            alt="Enjoy a hassle-free driving experience with
                                    cost-effective solutions." loading="lazy" fetchpriority="low"> </span>
                                </div>
                                <h2>Enjoy a hassle-free driving experience with
                                    cost-effective solutions.</h2>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </section>

    <section class="text-light jarallax benefitcont sectionpadtop pt-0" aria-label="section">
        <div class="sectionbeforeafter" style="position: absolute;"></div>
        <div class="overlayblack">
            <!-- <img src="{{ secure_asset('front') }}/images/carbg2.jpg" alt="" class="jarallax-img"> -->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-8 offset-lg-2 text-center">
                        <h2 class="text-black">Benefits of leasing With SMAS</h2>
                        <p class="text-black fo-13">Get extra benefits with safe, reliable and cost-effective
                            solutions.</p>
                        <div class="spacer-20"></div>
                    </div>


                </div>


                <div class="row smas2">
                    <div class="col-md-3">
                        <div class="text-center position-relative">
                            <div
                                class="step-icon mx-auto border rounded-circle d-flex align-items-center justify-content-center">
                                <img src="{{ secure_asset('front') }}/./images/benefit-1.avif" alt="No Down Payment"
                                    class="img-fluid" loading="lazy" fetchpriority="low">
                            </div>
                            <h4 class="mt-3 test-heading">No Down Payment</h4>
                            <p class="px-lg-3 mb-5 mb-lg-0 text-black">With SMAS India's car leasing policy,
                                you
                                can drive home your dream vehicle with zero down payment.</p>
                            <div class="arrow-icon position-absolute d-none d-lg-block"
                                style="top:50px; right:-25px">
                                <svg class="bi bi-arrow-right" fill="currentColor" height="30"
                                    viewbox="0 0 16 16" width="30" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"
                                        fill-rule="evenodd"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center position-relative">
                            <div
                                class="step-icon mx-auto border rounded-circle d-flex align-items-center justify-content-center">
                                <img src="{{ secure_asset('front') }}/./images/benefit-2.avif" alt="Planned Montly Rentals"
                                    class="img-fluid" loading="lazy" fetchpriority="low">
                            </div>
                            <h4 class="mt-3 test-heading">Planned Montly Rentals</h4>
                            <p class="px-lg-3 mb-5 mb-lg-0 text-black">Pay a fixed monthly lease rental that
                                covers Vehicle, Accessories, Maintenance, Insurance and other Value Added
                                Services
                                for the entire lease tenure.</p>
                            <div class="arrow-icon d-none d-lg-block position-absolute"
                                style="top:50px; right:-25px">
                                <svg class="bi bi-arrow-right" fill="currentColor" height="30"
                                    viewbox="0 0 16 16" width="30" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"
                                        fill-rule="evenodd"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center position-relative">
                            <div
                                class="step-icon mx-auto border rounded-circle d-flex align-items-center justify-content-center">
                                <img src="{{ secure_asset('front') }}/./images/benefit-3.avif" alt="Tax Saving Options"
                                    class="img-fluid" loading="lazy" fetchpriority="low">
                            </div>
                            <h4 class="mt-3 test-heading">Tax Saving Options</h4>
                            <p class="px-lg-3 mb-5 mb-lg-0 text-black">With SMAS India's company car policy,
                                you
                                get to save on taxes on your lease rental payments.</p>
                            <div class="arrow-icon d-none d-lg-block position-absolute"
                                style="top:50px; right:-25px">
                                <svg class="bi bi-arrow-right" fill="currentColor" height="30"
                                    viewbox="0 0 16 16" width="30" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z"
                                        fill-rule="evenodd"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center position-relative">
                            <div
                                class="step-icon mx-auto border rounded-circle d-flex align-items-center justify-content-center">
                                <img src="{{ secure_asset('front') }}/./images/setting.avif" alt="Customized Solutions"
                                    class="img-fluid" loading="lazy" fetchpriority="low">
                            </div>
                            <h4 class="mt-3 test-heading">Customized Solutions</h4>
                            <p class="px-lg-3 mb-5 mb-lg-0 text-black">SMAS India's leasing programme is
                                tailored to match your needs at competitive prices.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="section-cars" class="servicecont features">
        <div class="position-fix">
            <div class="bg"></div>
            <div class="bg bg2"></div>
            <div class="bg bg3"></div>
        </div>
        <div class="container watch">
            <div class="row video1 align-items-center">
                <div class="col-lg-6 col-12">
                    <h2>Watch to know more</h2>
                </div>
                <div class="col-lg-6 col-12">
                    <div class="video-custom">
                        {{-- <div class="play-pause">
                            <span type="button" class="play-btn" id="play_button" data-bs-toggle="modal"
                                data-bs-target="#exampleModal1"><i></i></span><span id="pause_button"
                                class="pause-btn"><i></i></span>
                        </div> --}}

                        {{-- <iframe class="iframeVideo"
                            src="{{ secure_asset('front/images/final_august_5.mp4') }}"
                            title="YouTube video player" frameborder="0" autoplay="0" allowfullscreen=""
                            sandbox=""
                            allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            referrerpolicy="strict-origin-when-cross-origin"></iframe> --}}
                            
                           {{-- <iframe class="iframeVideo" src="{{ secure_asset('front/images/final_august_5.mp4') }}"
                                    title="YouTube video player" frameborder="0" autoplay="" allowfullscreen=""
                                    allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                    referrerpolicy="strict-origin-when-cross-origin">
                                </iframe> --}}
                                  <video controls>
                                <source src="{{ secure_asset('front/images/final_august_5.mp4') }}" type="video/mp4">
                                <source src="{{ secure_asset('front/images/final_august_5.webm') }}" type="video/webm">
                                <source src="{{ secure_asset('front/images/final_august_5.ogv') }}" type="video/ogg">
                              </video>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- Modal -->
   {{-- <div class="modal modal-dialog-centered fade" id="exampleModal1" tabindex="-1"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content videopop">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <video id="video" width="100%" poster="" preload="none" controls>
                        <source src="{{secure_asset('front')}}/./images/final_august_5.mp4" data-wf-ignore="true">
                    </video>
                </div>

            </div>
        </div>
    </div> --}}
    
    
    
    <div class="modal modal-dialog-centered fade" id="GPTWModal" tabindex="-1"aria-labelledby="GPTWModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header" style="display: block;text-align: right;">
                    <button type="button" class="" data-bs-dismiss="modal" aria-label="Close" style="color: #fff;background-color: transparent;border: 0;"><span class="material-symbols-outlined">close</span></button>
                </div>
                <div class="modal-body GPTWModal">
                    <h2>You will be re-directed to an external site<a href="https://www.greatplacetowork.in/great/company/smas-auto-leasing-india-private-limited" target="_blank" rel="noopener noreferrer"style="text-decoration: underline;color: #0da9e9;margin-left: 10px;">Learn more</a></h2>
                </div>

            </div>
        </div>
    </div>


<section class="message_popup_footer">
   <div class="GPTW">
   <img width="100" src="{{secure_asset('front/images/GPTW-Certification-Badge.png') }}">
   <div class="GPTW_text">
      <h3>We Are A <br> <span>‘Great Place <br> to Work’</span></h3>
      <a href="#" data-bs-toggle="modal" data-bs-target="#GPTWModal" class="btn-arrow mt2 myBtn" tabindex="0">Learn More<span class="material-symbols-outlined ms-2">arrow_right_alt</span></a>
   </div>
   <div class="popupclose">
     <span class="material-symbols-outlined">close</span>  
   </div>
</div> 
</section>
    <section class="testimonial-cont">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-6 offset-lg-3 text-center">
                    <h2 class="">Our Clients Love Us</h2>
                    <p class="para-test text-black">Read our feedback provided by our precious clients, and
                        feel
                        the
                        happiness of our
                        service.</p>
                    <!-- <div class="spacer-20"></div> -->
                </div>

                <div class="col-lg-10 offset-lg-1">
                    <div class="col-lg-12">
                        <div id="items-carousel" class="owl-carousel test">
                            <div class="de-item testi-cont mb30">
                                <img src="{{ secure_asset('front') }}/images/comment-coma.webp" class="comment-coma"
                                    alt="" loading="lazy" fetchpriority="low">
                                <div class="d-info">
                                    <div class="d-text text-white text-center">
                                        <span class="rating-value" rating-value="4"></span>

                                        <div class="test-content">
                                            <p class="text-white">
                                                Congratulations to SMAS for successfully completing a great
                                                feat
                                                of 10 years and wishing many more years of success in
                                                this Industry.
                                                SMAS is providing excellent support to our organisation's
                                                car
                                                lease programme since year 2019. They ensure Employee
                                                experience without compromising on the Client's Organisation
                                                policy & standards. In addition, their proactive guidance
                                                to us on the critical changes or statutory amendments is
                                                highly
                                                appreciated. Their Quality of response, going extra mile
                                                on customer needs and responsiveness in dealing with
                                                Employees
                                                request is helping them to expand their business through
                                                peer-to-peer informal feedback on the service.
                                                Thank you and to your team. All the very Best to the
                                                individuals
                                                who are part of Team SMAS for continuously supporting
                                                our organization behind the scenes and front line. Keep
                                                Rocking!!!
                                            </p>
                                        </div>
                                        <h4 class="text-center">Karthikeyan Selvam
                                            <span>Standard Chartered</span>
                                        </h4>
                                    </div>
                                </div>
                                <div class="arrow_box"></div>
                            </div>

                            <div class="de-item testi-cont mb30">
                                <img src="{{ secure_asset('front') }}/images/comment-coma.webp" class="comment-coma"
                                    alt="" loading="lazy" fetchpriority="low">
                                <div class="d-info">
                                    <div class="d-text text-white text-center">
                                        <span class="rating-value" rating-value="4"></span>

                                        <div class="test-content">
                                            <p class="text-white">
                                                "Every step of the procedure, from our conversation to the
                                                delivery of the vehicle, was excellent! Nothing complicated
                                                at all; everything was completed quickly, including our
                                                unique
                                                customised demands of commercial vehicles.
                                                I found that the SMAS India staff and our account Manager
                                                Vikas
                                                Ratan Verma are dedicated and committed to their
                                                wording, and I heartily endorse it."
                                                Best wishes for SMAS India's tenth anniversary!
                                            </p>
                                        </div>
                                        <h4 class="text-center">Vinay Kumar Gupta
                                            <span>KARL STORZ Endoscopy India Pvt. Ltd.</span>
                                        </h4>
                                    </div>
                                </div>
                                <div class="arrow_box"></div>
                            </div>

                            <div class="de-item testi-cont mb30">
                                <img src="{{ secure_asset('front') }}/images/comment-coma.webp"" class="comment-coma"
                                    alt="" loading="lazy" fetchpriority="low">
                                <div class="d-info">
                                    <div class="d-text text-white text-center">
                                        <span class="rating-value" rating-value="4"></span>

                                        <div class="test-content">
                                            <p class="text-white">
                                                When we started reaching out to lenders for expansion in the
                                                ambulance business, SMAS Auto Leasing India Pvt Ltd was one
                                                of the first to fund us. ZHL has been associated with SMAS
                                                Auto
                                                Leasing India since Feb 2019 when it financed 110
                                                Vehicles for its 102 operations in Odisha and Madhya
                                                Pradesh.
                                                Subsequently, SMAS have supported us in the rollout of
                                                Ambulances for our Private Business and also for the
                                                National
                                                Highway Authority project.
                                                We would like to express our gratitude to SMAS Auto Leasing
                                                India Pvt Ltd for the continued support and indeed SMAS has
                                                been a
                                                valuable partner for ZHL contributing in our growth and
                                                success.
                                                Our lead promoter and Chairman Mr Shaffi Mather also has
                                                expressed his sincere appreciation for the role played by
                                                SMAS
                                                in our success. We look forward to a mutually beneficial
                                                partnership for many years to come
                                            </p>
                                        </div>
                                        <h4 class="text-center">Manjula Easwaran
                                            <span>Ziqitza Health Care Limited</span>
                                        </h4>
                                    </div>
                                </div>
                                <div class="arrow_box"></div>
                            </div>

                            <div class="de-item testi-cont mb30">
                                <img src="{{ secure_asset('front') }}/images/comment-coma.webp" class="comment-coma" alt="" loading="lazy" fetchpriority="low">
                                <div class="d-info">
                                    <div class="d-text text-white text-center">
                                        <span class="rating-value" rating-value="4"></span>

                                        <div class="test-content">
                                            <p class="text-white">
                                                We love the flexibility of the services and quality of
                                                members
                                                to ease out the Vehicle Leasing's process for our
                                                employees.
                                                The Sales Team is hands-on to answer our queries always. We
                                                wish
                                                SMAI team, best of growth and promise to extend
                                                complete support in all their future endeavor
                                            </p>
                                        </div>
                                        <h4 class="text-center">Rubeena Rawa
                                            <span>CREST DIGITEL PRIVATE LIMITED</span>
                                        </h4>
                                    </div>
                                </div>
                                <div class="arrow_box"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                </div>
            </div>
        </div>
    </section>
</div>
  @endsection
  
  