@extends('front.layouts.masterhome')
@section('meta_title', 'BS6 Compliance: What Corporate Fleet Owners Must Know')
@section('meta_description', 'Understand BS6 compliance requirements for corporate fleet owners and how to ensure your vehicles meet the latest emission standards.')
@section('section')
<div class="no-bottom no-top" id="content">
    <div id="top"></div>

    <!-- section begin -->
    <section id="subheader" class="jarallax text-light">
        <img src="{{ asset('front') }}/images/background/subheader.jpg" class="jarallax-img" alt="">
        <div class="center-y relative text-center">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 text-center">
                        <h1>BS6 Compliance for Vehicles- What Corporate Fleet Owners must know?</h1>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </section>
    <!-- section close -->

    <section aria-label="section" class="blog_details_sec">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-8">
                    <div class="blog-read">

                        <div class="blog_deatils_imgbox">
                            <img alt="" src="{{ asset('front') }}/images/news/blog-detail9.jpg"
                                class="img-fullwidth mb30">
                            <h2>19<span>MAR</span></h2>
                        </div>

                        <div class="post-text">

                            <h2>BS6 Compliance for Vehicles- What Corporate Fleet Owners must know?</h2>

                            <p>With just over a month for the enactment of BS6 norms, Indian automakers seem
                                edgy about the future purchases. So let’s
                                dive deep into the upcoming BS6 emission norms and the significance of BS6
                                Compliance in India.</p>

                            <h3>The Obligation of BS6 Emission Norms in India</h3>

                            <p>The Supreme Court in its decree made it evident that sale of BS4 vehicles (cars,
                                two-wheelers or commercial vehicles)
                                will be stopped in India post the BS6 deadline on April 1, 2020. The apex court
                                bench pronounced that only BS6 compliant
                                vehicles shall be available for sale or purchase after April 1, 2020. The bench
                                also stated the need of the hour to make
                                a shift to a cleaner fuel use all across the country in accordance with the
                                Paris Climate Agreement signed by India in
                                2016. It is now evident that the Indian government takes hold of the
                                responsibility to lessen its carbon-footprint by
                                35-55% within the next 12 years from what was put down in 2005.</p>

                            <p>As a result, the government in collaboration with some oil companies has already
                                initiated the roll out of BS6 compliant
                                fuels in some parts of the country- like certain pumps in the Delhi/NCR region.
                                Although the judgment did not fall in
                                favor of the automobile industry, which is already sparing no effort to meet the
                                BS6 deadline, this BS6 compliance move
                                is undoubtedly great for the general public as cleaner and less polluting cars
                                are the need of the hour.</p>


                            <h3>BS6 Ready vs BS6 Compliant</h3>

                            <p>Confused about BS6 ready and BS6 Compliant vehicles? Well, today keeping up
                                healthy relations with our environment is
                                really significant. And this is why automakers are working hard upon the
                                powertrain to manufacture vehicles that are
                                compliant to the BS6 emission standards.</p>

                            <h6>BS6 Ready Engine?</h6>

                            <p>There is a considerable difference between BS6 ready engine and BS6 compliant
                                engine and comes with two explanations:</p>
                            <ul>
                                <li>Automobile companies possess the technology to manufacture an engine that
                                    runs on BS6 fuel and adheres to BS6 emission
                                    norms. They have not been manufactured or launched yet.</li>
                                <li>The engine manufactured can run on BS6 fuel however the emissions do not
                                    follow the new norms. Almost all BS4 vehicles
                                    in India can run on BS6 fuel and the lubricating quality of new fuel is
                                    somewhat similar to the BS4 fuel.</li>
                            </ul>
                            <h6>BS6 Compliant Engine?</h6>

                            <p>The vehicles running in India with a BS6 compliant engine run on BS6 fuel and
                                produce emissions as per the BS6 compliant
                                emission norms. Very few cars in India are BS6 compliant and there is no BS6
                                compliant diesel engine vehicle as engine
                                runs only on BS6 diesel fuel.</p>

                            <h3>How BS6 Compliance will affect vehicle fleet owners and businesses?</h3>

                            <p>With the new BS6 emissions regulations ringing in from April 1, 2020; state of
                                the art technology will be required to
                                keep emissions in check, especially the new diesel engine vehicles. Diesel cars
                                will require a complete new technology
                                in order to cut back on emissions and as a result, new add-ons are likely to
                                bring an upswing in the prices of diesel
                                cars and widen the gap between a new petrol car and a new diesel car by around
                                2.5 lakh rupees if premium hatchbacks and
                                compact sedan are taken into consideration.</p>
                            <p>Diesel vehicles and economic class motorcycles will witness a sharp rise in
                                price, and this might keep buyers away for
                                some time. In addition to it, the resale value for BS4 diesel cars is likely to
                                decrease in few years (2022-2024) or
                                earlier in case the government passes some rule that impacts the validity of BS4
                                diesel cars in India. People would not
                                bother driving around their BS4 diesel cars until and unless forced by law to
                                shift to BS6 vehicles. However, it will be
                                better to hold your horses till 2021 if none of the current cars satisfy your
                                itch to upgrade. Well, all the hoopla
                                around BS4 and BS6 is likely to settle down by that time and you will eventually
                                have more clarity. With prices of BS6
                                diesel engines to witness an upswing, customers also have the choice to choose
                                vehicle leasing services in India with or
                                without maintenance, all depending on the requirement. Auto leasing in India can
                                cater to start-up entrepreneurs, MSMEs
                                and corporate professionals.</p>

                            <h3>How Vehicle Leasing Solutions can be the most Viable Option?</h3>

                            <p>Well, the benefits of leasing go far beyond the perks of BS6 compliant vehicles.
                                With vehicle leasing solutions, you can
                                easily drive around with relatively less monthly fees and mechanical maintenance
                                charges. Corporate car leasing
                                companies like SMAS India can prove to be the most viable option in today’s BS6
                                compliant auto market. With car prices
                                likely to increase substantially, businesses will prefer to have a corporate
                                lease vehicle for 2-3 years and will avail
                                a wide variety of tax benefits for the business. Moreover, companies that lease
                                vehicles are also aware of the fact that
                                their cost of maintenance and repairs are already included under the lease.</p>
                            <p>Therefore, it can be concluded that vehicle fleet solutions in India are likely
                                to bring a pragmatic shift amongst
                                businesses and corporates from April 1, 2020.</p>

                            <blockquote>
                                <div class="icon-box3"><i class="fa fa-quote-left"></i></div>
                                <h6>The One-Off</h6>
                                <p>Commercial vehicles sale have remained low in the last one year due to
                                    enhanced efficiency of trucks because of increase
                                    in freight carrying capacity and implementation of GST. But the reduction in
                                    freight from manufacturing sector has
                                    curtailed the income of fleet owners which further have also hit demand for
                                    such vehicles. And apart from lack of
                                    demand, lessening financing options available from the NBFC sector have also
                                    kept fleet owners from the market.</p>
                            </blockquote>
                        </div>

                    </div>


                </div>

                <div id="sidebar" class="col-md-4">
                    <!-- <div class="widget">
                            <h4>Share With Friends</h4>
                            <div class="small-border"></div>
                            <div class="de-color-icons">
                                <span><i class="fa fa-twitter fa-lg"></i></span>
                                <span><i class="fa fa-facebook fa-lg"></i></span>
                                <span><i class="fa fa-reddit fa-lg"></i></span>
                                <span><i class="fa fa-linkedin fa-lg"></i></span>
                                <span><i class="fa fa-pinterest fa-lg"></i></span>
                                <span><i class="fa fa-stumbleupon fa-lg"></i></span>
                                <span><i class="fa fa-delicious fa-lg"></i></span>
                                <span><i class="fa fa-envelope fa-lg"></i></span>
                            </div>
                        </div> -->

                    <div class="widget widget-post">
                        <h4>Recent Posts</h4>
                        <div class="small-border"></div>
                        <ul class="de-bloglist-type-1">
                            <li>
                                <div class="d-image">
                                    <img src="{{ asset('front') }}/images/news-thumbnail/thumb-1.jpg" alt="">
                                </div>
                                <div class="d-content">
                                    <a href="{{ route('home.questions_to_ask_your_fleet_consultancy_service_provider') }}">
                                        <h4>4 Questions to ask your Fleet
                                            Consultancy Service Provider</h4>
                                    </a>
                                    <div class="d-date">May 20, 2020</div>
                                </div>
                            </li>
                            <li>
                                <div class="d-image">
                                    <img src="{{ asset('front') }}/images/news-thumbnail/thumb-2.jpg" alt="">
                                </div>
                                <div class="d-content">
                                    <a
                                        href="{{ route('home.how_smas_india_delivers_top_notch_fleet_management_service_at_your_doorstep') }}">
                                        <h4>How SMAS India delivers top-notch
                                            Fleet Management Service at your doorstep?</h4>
                                    </a>
                                    <div class="d-date">May 22, 2020</div>
                                </div>
                            </li>
                            <li>
                                <div class="d-image">
                                    <img src="{{ asset('front') }}/images/news-thumbnail/thumb-3.jpg" alt="">
                                </div>
                                <div class="d-content">
                                    <a
                                        href="{{ route('home.how_can_vehicle_leasing_help_your_business_operate_smoothly_post_covid_19') }}">
                                        <h4>How can Vehicle Leasing help your
                                            business operate smoothly post COVID-19?</h4>
                                    </a>
                                    <div class="d-date">July 17, 2020</div>
                                </div>
                            </li>
                            <li>
                                <div class="d-image">
                                    <img src="{{ asset('front') }}/images/news-thumbnail/thumb-4.jpg" alt="">
                                </div>
                                <div class="d-content">
                                    <a href="{{ route('home.going_digital_is_the_new_black') }}">
                                        <h4>Going Digital is the New
                                            Black</h4>
                                    </a>
                                    <div class="d-date">July 20, 2020</div>
                                </div>
                            </li>
                        </ul>
                    </div>

                    <!-- <div class="widget widget-text">
                        <h4>About Us</h4>
                        <div class="small-border"></div>
                        <p class="small no-bottom">
                            Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni
                        </p>
                    </div> -->


                    <!-- <div class="widget widget_tags">
                        <h4>Tags</h4>
                        <div class="small-border"></div>
                        <ul>
                            <li><a href="#link">accommodation</a></li>
                            <li><a href="#link">holiday</a></li>
                            <li><a href="#link">hostel</a></li>
                            <li><a href="#link">hotel</a></li>
                            <li><a href="#link">travel</a></li>
                            <li><a href="#link">inn</a></li>
                            <li><a href="#link">lodge</a></li>
                            <li><a href="#link">motel</a></li>
                            <li><a href="#link">resort</a></li>
                            <li><a href="#link">travel</a></li>
                            <li><a href="#link">tourism</a></li>
                            <li><a href="#link">vacation</a></li>
                        </ul>
                    </div> -->

                </div>
            </div>
        </div>
    </section>





</div>
@endsection