// app/Http/Middleware/ForceHttpsAssets.php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ForceHttpsAssets
{
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        // Only process HTML responses
        if (stripos($response->headers->get('Content-Type') ?? '', 'text/html') !== false) {
            $content = $response->getContent();

            // Your domain(s) to secure (add more if needed)
            $domains = [
                'www.smasindia.com',
                'smasindia.com',
            ];

            foreach ($domains as $domain) {
                // Replace only insecure links from your own domain
                $pattern = '#http://' . preg_quote($domain, '#') . '#i';
                $content = preg_replace($pattern, 'https://' . $domain, $content);
            }

            $response->setContent($content);
        }

        return $response;
    }
}
