<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AddBreachPadding
{
    public function handle(Request $request, Closure $next): Response
    {
        /** @var \Symfony\Component\HttpFoundation\Response $response */
        $response = $next($request);

        // Sirf HTML par chale
        if (stripos($response->headers->get('Content-Type', ''), 'text/html') === false) {
            return $response;
        }

        // Sirf sensitive pages (checkout, account, order etc.)
        $uri = $request->getRequestUri();
        if (!preg_match('/checkout|account|order/i', $uri)) {
            return $response;
        }

        // Random padding generate karo (32–128 bytes)
        $pad = '<!--pad:' . bin2hex(random_bytes(random_int(32, 128))) . '-->';

        // HTML content modify karo
        $content = $response->getContent();
        if (stripos($content, '</body>') !== false) {
            // </body> tag ke pehle padding insert karo
            $content = str_ireplace('</body>', $pad . "\n</body>", $content);
        } else {
            // Agar body nahi hai to end me add kar do
            $content .= $pad;
        }
        $response->setContent($content);

        // Content-Length remove karo taaki browser khud calculate kare
        $response->headers->remove('Content-Length');

        return $response;
    }
}
